/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2013, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.test.integration.mgmt.access;

import java.io.InputStream;

import org.apache.commons.io.FileUtils;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.jboss.as.test.shared.AssumeTestGroupUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;

/**
 * Starts a LDAP server and WildFly before running the tests.
 *
 * @author Ladislav Thon <lthon@redhat.com>
 */
public class LdapRoleMappingG2UTestCase extends AbstractPropertiesRoleMappingTestCase {
    private static DirectoryService directoryService;
    private static LdapServer ldapServer;

    @BeforeClass
    @CreateDS(
            name = "WildFlyDS",
            factory = org.jboss.as.test.integration.mgmt.access.ldap.InMemoryDirectoryServiceFactory.class,
            partitions = @CreatePartition(name = "wildfly", suffix = "dc=wildfly,dc=org"),
            allowAnonAccess = true
    )
    @CreateLdapServer(
            transports = @CreateTransport(protocol = "LDAP", address = "localhost", port = 10389),
            allowAnonymousAccess = true
    )
    public static void setUp() throws Exception {
        // Legacy security won't work on SE 14 or later; 11 is the last SE where EAP will support it
        AssumeTestGroupUtil.assumeJDKVersionBefore(12);
        directoryService = DSAnnotationProcessor.getDirectoryService();
        SchemaManager schemaManager = directoryService.getSchemaManager();
        InputStream ldif = LdapRoleMappingG2UTestCase.class.getResourceAsStream("/" + LdapRoleMappingG2UTestCase.class.getSimpleName() + ".ldif");
        for (LdifEntry ldifEntry : new LdifReader(ldif)) {
            directoryService.getAdminSession().add(new DefaultEntry(schemaManager, ldifEntry.getEntry()));
        }
        ldapServer = ServerAnnotationProcessor.getLdapServer(directoryService);

        startServer();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (AssumeTestGroupUtil.isJDKVersionBefore(12)) {
            stopServer();

            ldapServer.stop();
            directoryService.shutdown();
            FileUtils.deleteDirectory(directoryService.getInstanceLayout().getInstanceDirectory());
        }
    }
}
