/*
 * Copyright 2022 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.migration.eap.task.hostexclude;

import org.jboss.migration.core.jboss.HostExclude;
import org.jboss.migration.core.jboss.HostExcludes;
import org.jboss.migration.core.jboss.JBossExtensionNames;
import org.jboss.migration.wfly10.config.task.hostexclude.AddHostExcludes;

/**
 * @author emmartins
 */
public class EAP8_0AddHostExcludes<S> extends AddHostExcludes<S> {

    private static final HostExcludes HOST_EXCLUDES = HostExcludes.builder()
            .hostExclude(HostExclude.builder()
                    .name("EAP62")
                    .release("EAP6.2")
                    .excludedExtension("org.wildfly.extension.batch.jberet")
                    .excludedExtension("org.wildfly.extension.bean-validation")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension("org.wildfly.extension.clustering.singleton")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.core-management")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.discovery")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension("org.wildfly.extension.elytron")
                    .excludedExtension("org.wildfly.extension.io")
                    .excludedExtension("org.wildfly.extension.messaging-activemq")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension("org.wildfly.extension.picketlink")
                    .excludedExtension("org.wildfly.extension.request-controller")
                    .excludedExtension("org.wildfly.extension.rts")
                    .excludedExtension("org.wildfly.extension.security.manager")
                    .excludedExtension("org.wildfly.extension.undertow")
                    .excludedExtension("org.wildfly.iiop-openjdk")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .hostExclude(HostExclude.builder()
                    .name("EAP63")
                    .release("EAP6.3")
                    .excludedExtension("org.wildfly.extension.batch.jberet")
                    .excludedExtension("org.wildfly.extension.bean-validation")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension("org.wildfly.extension.clustering.singleton")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.core-management")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.discovery")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension("org.wildfly.extension.elytron")
                    .excludedExtension("org.wildfly.extension.io")
                    .excludedExtension("org.wildfly.extension.messaging-activemq")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension("org.wildfly.extension.request-controller")
                    .excludedExtension("org.wildfly.extension.rts")
                    .excludedExtension("org.wildfly.extension.security.manager")
                    .excludedExtension("org.wildfly.extension.undertow")
                    .excludedExtension("org.wildfly.iiop-openjdk")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .hostExclude(HostExclude.builder()
                    .name("EAP64")
                    .release("EAP6.4")
                    .excludedExtension("org.wildfly.extension.batch.jberet")
                    .excludedExtension("org.wildfly.extension.bean-validation")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension("org.wildfly.extension.clustering.singleton")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.core-management")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.discovery")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension("org.wildfly.extension.elytron")
                    .excludedExtension("org.wildfly.extension.io")
                    .excludedExtension("org.wildfly.extension.messaging-activemq")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension("org.wildfly.extension.request-controller")
                    .excludedExtension("org.wildfly.extension.rts")
                    .excludedExtension("org.wildfly.extension.security.manager")
                    .excludedExtension("org.wildfly.extension.undertow")
                    .excludedExtension("org.wildfly.iiop-openjdk")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .hostExclude(HostExclude.builder()
                    .name("EAP64z")
                    .apiVersion("1","8")
                    .excludedExtension("org.wildfly.extension.batch.jberet")
                    .excludedExtension("org.wildfly.extension.bean-validation")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension("org.wildfly.extension.clustering.singleton")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.core-management")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.discovery")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension("org.wildfly.extension.elytron")
                    .excludedExtension("org.wildfly.extension.io")
                    .excludedExtension("org.wildfly.extension.messaging-activemq")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension("org.wildfly.extension.request-controller")
                    .excludedExtension("org.wildfly.extension.rts")
                    .excludedExtension("org.wildfly.extension.security.manager")
                    .excludedExtension("org.wildfly.extension.undertow")
                    .excludedExtension("org.wildfly.iiop-openjdk")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .hostExclude(HostExclude.builder()
                    .name("EAP70")
                    .release("EAP7.0")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.core-management")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.discovery")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension("org.wildfly.extension.elytron")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .hostExclude(HostExclude.builder()
                    .name("EAP71")
                    .release("EAP7.1")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .hostExclude(HostExclude.builder()
                    .name("EAP72")
                    .release("EAP7.2")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .hostExclude(HostExclude.builder()
                    .name("EAP73")
                    .release("EAP7.3")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .hostExclude(HostExclude.builder()
                    .name("EAP74")
                    .release("EAP7.4")
                    .excludedExtension(JBossExtensionNames.CLUSTERING_EJB)
                    .excludedExtension(JBossExtensionNames.ELYTRON_OIDC_CLIENT)
                    .excludedExtension(JBossExtensionNames.OPENTELEMETRY)
            )
            .build();

    public EAP8_0AddHostExcludes() {
        super(HOST_EXCLUDES);
    }
}
