/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall;

import org.jboss.installer.core.InstallationData;
import org.jboss.installer.postinstall.server.DomainServer;
import org.jboss.installer.postinstall.server.StandaloneServer;

public interface CliPostInstallTask extends PostInstallTask {

    /**
     * Applies changes to the server's standalone configuration. Each supported configuration will receive separate call to this method.
     * {@code server} will be running during the call.
     * <p>
     * Returning {@code false} from the task will prevent any subsequent tasks from running and fail the installation.
     *
     * @param data
     * @param server  - running server instance
     * @param printer
     * @return true if the task was successful, false otherwise
     */
    boolean applyToStandalone(InstallationData data, StandaloneServer server, TaskPrinter printer);

    /**
     * Applies changes to the server's domain configuration. Each supported configuration will receive separate call to this method.
     * {@code server} will be running during the call.
     * <p>
     * Returning {@code false} from the task will prevent any subsequent tasks from running and fail the installation.
     *
     * @param data
     * @param server  - running server instance
     * @param printer
     * @return true if the task was successful, false otherwise
     */
    boolean applyToDomain(InstallationData data, DomainServer server, TaskPrinter printer);
}
