/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall.ldap;

import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

import java.util.List;

import static org.jboss.as.controller.operations.common.Util.createEmptyOperation;

public class SecurityDomain {

    public ModelNode createSecurityDomain(Model config) {
        ModelNode op = createEmptyOperation("add",
                PathAddress.pathAddress("subsystem", "elytron").append("security-domain", config.getDomainName()));
        final ModelNode realm = new ModelNode();
        realm.get("realm").set(config.getRealmName());
        op.get("realms").set(List.of(realm));
        op.get("default-realm").set(config.getRealmName());
        op.get("permission-mapper").set("default-permission-mapper");
        if (config.isGroupDecoder()) {
            op.get("role-decoder").set("groups-to-roles");
        }

        return op;
    }

    public static class Model {
        private final String domainName;
        private final String realmName;
        private final boolean groupDecoder;

        public Model(String domainName, String realmName, boolean groupDecoder) {
            this.domainName = domainName;
            this.realmName = realmName;
            this.groupDecoder = groupDecoder;
        }

        public String getDomainName() {
            return domainName;
        }

        public String getRealmName() {
            return realmName;
        }

        public boolean isGroupDecoder() {
            return groupDecoder;
        }
    }
}
