/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.validators;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.ValidationResult;
import org.jboss.installer.postinstall.ldap.LDAPUtils;
import org.jboss.installer.postinstall.task.LDAPSetupTask;

import javax.naming.directory.DirContext;

/** Verify that we can authenticate with the LDAP server. */
public class LDAPValidator {

    public static final String LDAP_SCREEN_CONNECTION_ERROR = "ldap_screen.connection.error";
    private LanguageUtils langUtils;

    public LDAPValidator(LanguageUtils langUtils) {
        this.langUtils = langUtils;
    }

    public ValidationResult validateData(LDAPSetupTask.Config config) {
        if (!connectToLdapConnection(config)){
            return ValidationResult.error(langUtils.getString(LDAP_SCREEN_CONNECTION_ERROR));
        }
        return ValidationResult.ok();
    }

    private boolean connectToLdapConnection(LDAPSetupTask.Config config){
        String dnServer = config.getUrl();
        String dn = config.getDn();
        String dnPassword = config.getPassword();
        DirContext ctx = LDAPUtils.makeConnection(dnServer, dn, dnPassword);
        return ctx != null;
    }

}
