/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.validators;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.ValidationResult;

public class PasswordEqualityValidator {

    public static final String PASSWORD_NOT_MATCHED = "admin_creation_screen.confirmation_password_match";
    public static final String NO_PASSWORD = "admin_creation_screen.empty_password";
    public static final String NO_PASSWORD_CONFIRMATION = "admin_creation_screen.empty_password_confirmation";
    protected final LanguageUtils langUtils;

    public PasswordEqualityValidator(LanguageUtils langUtils) {
        this.langUtils = langUtils;
    }

    public ValidationResult validate(String password1, String password2) {
        return validate(password1, password2, null);
    }

    public ValidationResult validate(String password1, String password2, String prefixMessageKey) {
        if (password1 == null || password1.isEmpty()) {
            return ValidationResult.error((prefixMessageKey != null ? langUtils.getString(prefixMessageKey) + ": " : "") + langUtils.getString(NO_PASSWORD));
        }
        if (password2 == null || password2.isEmpty()) {
            return ValidationResult.error((prefixMessageKey != null ? langUtils.getString(prefixMessageKey) + ": " : "") + langUtils.getString(NO_PASSWORD_CONFIRMATION));
        }
        if (!password1.equals(password2)) {
            return ValidationResult.error((prefixMessageKey != null ? langUtils.getString(prefixMessageKey) + ": " : "") + langUtils.getString(PASSWORD_NOT_MATCHED));
        }
        return ValidationResult.ok();
    }
}
