/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.installer.actions.impl;

import static org.assertj.core.api.Assertions.assertThat;

import java.nio.file.FileSystemException;

import org.jboss.galleon.ProvisioningException;
import org.jboss.installer.actions.ActionException;
import org.jboss.installer.test.utils.MockLanguageUtils;
import org.junit.Test;

public class ProvisioningExceptionHandlerTest {

    @Test
    public void nestedExceptionIsExhasted() throws Exception {
        final ActionException root = new ProvisioningExceptionHandler(new MockLanguageUtils()).handle(new ProvisioningException(new Exception(new Exception("root"))));

        assertThat(root.getMessage())
                .isEqualTo("install.eap.provision.failed");
    }

    @Test
    public void nestedFileNameExceptionIsRead() throws Exception {
        final ActionException root = new ProvisioningExceptionHandler(new MockLanguageUtils()).handle(new ProvisioningException(new Exception(new FileSystemException("File name too long"))));

        assertThat(root.getMessage())
                .isEqualTo("install.eap.provision.error.path_too_long");
    }
}