package org.jboss.installer.common;

import org.jboss.installer.core.MnemonicUtils;
import org.jboss.installer.test.utils.MockLanguageUtils;
import org.junit.Test;

import static javax.swing.JFileChooser.FILES_ONLY;
import static org.junit.Assert.*;

public class FileChooserPanelTest {

    @Test
    public void invalidCharacterThrowsException() {
        final FileChooserPanel fileChooser = FileChooserPanel.builder(new MockLanguageUtils(), FILES_ONLY ,new MnemonicUtils()).build();

        fileChooser.setText("wrong\0text");

        assertThrows(FileChooserPanel.InvalidPathException.class, ()->fileChooser.asPath());
        assertThrows(FileChooserPanel.InvalidPathException.class, ()->fileChooser.asPathOrUrl());
    }

    @Test
    public void asPathReturnsNullOnEmptyText() throws Exception {
        final FileChooserPanel fileChooser = FileChooserPanel.builder(new MockLanguageUtils(), FILES_ONLY ,new MnemonicUtils()).build();

        fileChooser.setText("");
        assertNull(fileChooser.asPath());
        fileChooser.setText("  ");
        assertNull(fileChooser.asPath());
    }
}