/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2023 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.installer.core;

import org.jboss.installer.actions.impl.InstallEap;
import org.junit.Test;
import org.wildfly.prospero.api.ProvisioningProgressEvent;

import java.beans.PropertyChangeSupport;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

public class UnarchiveProgressCallbackImplTest {

    // Create a mock PropertyChangeSupport object
    private PropertyChangeSupport propertyChangeSupport = mock(PropertyChangeSupport.class);

    @Test
    public void testUnarchiveProgressCallback() {

        UnarchiveProgressCallbackImpl callback = new UnarchiveProgressCallbackImpl(propertyChangeSupport);
        callback.unarchiveStarted();
        verify(propertyChangeSupport,times(1)).firePropertyChange(ProvisioningProgressEvent.EventType.STARTING.name(), null, InstallEap.Stage.ZIP_EXTRACT);

        callback.unarchiveUpdate(50, 100);
        verify(propertyChangeSupport,times(1)).firePropertyChange(ProvisioningProgressEvent.EventType.UPDATE.name(), null,
                new InstallEap.Progress(null, 50, InstallEap.Stage.ZIP_EXTRACT));

        callback.unarchiveFinished();
        verify(propertyChangeSupport,times(1)).firePropertyChange(ProvisioningProgressEvent.EventType.COMPLETED.name(), null, InstallEap.Stage.ZIP_EXTRACT);
    }

}
