/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.jboss.installer.validators;

import org.jboss.installer.core.ValidationResult;
import org.jboss.installer.test.utils.MockLanguageUtils;
import org.junit.Assert;
import org.junit.Test;

public class IntRangeValidatorTest {

    private final IntRangeValidator minValidator = new IntRangeValidator(new MockLanguageUtils(), 1);
    private final IntRangeValidator minMaxValidator = new IntRangeValidator(new MockLanguageUtils(), 1, 100);

    @Test
    public void testStringValue() {
        Assert.assertEquals(ValidationResult.error("wrong type").getResult(), minValidator.validate("text").getResult());
    }

    @Test
    public void testMinValue() {
        Assert.assertEquals(ValidationResult.error("invalid min value").getResult(), minValidator.validate("0").getResult());
        Assert.assertEquals(ValidationResult.ok().getResult(), minValidator.validate("22").getResult());
    }

    @Test
    public void testMaxValue() {
        Assert.assertEquals(ValidationResult.error("invalid max value").getResult(), minMaxValidator.validate("200").getResult());
    }
}
