/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2017, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.wildfly.extension.datasources.agroal;

import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.security.CredentialReferenceWriteAttributeHandler;

/**
 * Operations common to XA and non-XA DataSources
 *
 * @author <a href="lbarreiro@redhat.com">Luis Barreiro</a>
 */
class AbstractDataSourceOperations {

    static final OperationStepHandler STATISTICS_ENABLED_WRITE_OPERATION = new ModelOnlyWriteAttributeHandler(AbstractDataSourceDefinition.STATISTICS_ENABLED_ATTRIBUTE);

    static final OperationStepHandler CONNECTION_FACTORY_WRITE_OPERATION = new ModelOnlyWriteAttributeHandler(AbstractDataSourceDefinition.CONNECTION_FACTORY_ATTRIBUTE.getValueTypes());

    static final OperationStepHandler CONNECTION_POOL_WRITE_OPERATION = new ModelOnlyWriteAttributeHandler(AbstractDataSourceDefinition.CONNECTION_POOL_ATTRIBUTE.getValueTypes());

    static final OperationStepHandler CREDENTIAL_REFERENCE_WRITE_OPERATION = new CredentialReferenceWriteAttributeHandler(AbstractDataSourceDefinition.CREDENTIAL_REFERENCE);

    // --- //

    // --- //
}

