/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2023 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.installer.screens;

import org.jboss.installer.core.InstallationData;
import org.jboss.installer.core.LanguageUtils;

import javax.swing.JPanel;
import javax.swing.Box;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;


public class SummaryScreen extends DefaultScreen {
    public static final String NAME = "SummaryScreen";
    public static final String DESCRIPTION_CHANGES_KEY = "summary.description.changes";
    public static final String DESCRIPTION_NO_CHANGES_KEY = "summary.description.no_changes";
    public static final String SUBTITLE_KEY = "summary.subtitle";
    private static final String TITLE_KEY = "summary_screen.title";
    private InstallationData installationData;

    public SummaryScreen(LanguageUtils langUtils) {
        super(langUtils);
    }

    @Override
    public String getTitle() {
        return langUtils.getString(TITLE_KEY);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public JPanel getContent() {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        final GridBagConstraints c = initializeConstraints();
        c.gridwidth = 3;

        c.insets = DESCRIPTION_INSET;

        final Collection<ConfigSummaryPanel> summaries = installationData.getSummaries();
        if (summaries.isEmpty()) {
            content.add(createFieldLabel(DESCRIPTION_NO_CHANGES_KEY), c);
            c.gridy++;
        } else {
            content.add(createDescription(DESCRIPTION_CHANGES_KEY), c);
            c.gridy++;


            c.insets = FIELD_ROW_INSET;
            content.add(createFieldLabel(SUBTITLE_KEY), c);
            c.gridy++;

            c.insets = new Insets(0, 10, 10, 0);

            for (ConfigSummaryPanel summary : summaries) {
                content.add(summary, c);
                c.gridy++;
            }
        }

        c.weighty = 1;
        content.add(Box.createVerticalBox(), c);

        return content;
    }

    @Override
    public void load(InstallationData installationData) {
        this.installationData = installationData;
    }
}
