/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.core;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;

import org.jboss.installer.auto.AutomaticInstallationParsingException;
import org.jboss.installer.postinstall.PostInstallTask;
import org.jboss.installer.screens.ConfigSummaryPanel;
import org.junit.Test;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

public class InstallDataTest {

    @Test
    public void saveConfigData() {
        final InstallationData installationData = new InstallationData();
        final TestConfig config = new TestConfig();

        installationData.putConfig(config);

        assertEquals(config, installationData.getConfig(TestConfig.class));
    }

    @Test
    public void removeConfigAndPostInstallTaskTest() {
        final InstallationData data = new InstallationData();
        final TestConfig config = new TestConfig();
        data.putConfig(config);
        data.removeConfig(TestConfig.class);
        assertNull(data.getConfig(TestConfig.class));
    }

    @Test
    public void removePostInstallTaskTest() {
        final InstallationData data = new InstallationData();
        data.addPostInstallTask(PostInstallTask.ChangePortConfiguration);
        data.removePostInstallTask(PostInstallTask.ChangePortConfiguration);
        assertEquals(0, data.getPostInstallTasks().size());
    }

    @Test
    public void removeDeactivatedSummaries() {
        final InstallationData data = new InstallationData();

        data.updateSummary("TEST.1", "TEST.1", new HashMap<>());
        data.updateSummary("TEST.2", "TEST.2", new HashMap<>());

        data.removeSummaries(List.of("TEST.2"));

        assertThat(data.getSummaries())
                .map(ConfigSummaryPanel::getDescription)
                .containsExactlyInAnyOrder("TEST.1");
    }

    static class TestConfig implements InstallationData.PostInstallConfig {

        @Override
        public XMLEventReader serialize(XMLEventFactory eventFactory, Set<String> variables) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deserialize(XMLEventReader reader, BiFunction<String, String, String> variableResolver) throws AutomaticInstallationParsingException {
            throw new UnsupportedOperationException();
        }
    }
}
