package org.jboss.installer.test.utils;

import static org.jboss.installer.actions.impl.MavenLocalRepositoryHelper.determineLocalRepository;
import static org.jboss.installer.postinstall.task.jsf.MyFacesJsfLibrarySetup.MYFACES_API_ARTIFACT_ID;
import static org.jboss.installer.postinstall.task.jsf.MyFacesJsfLibrarySetup.MYFACES_GROUP_ID;
import static org.jboss.installer.postinstall.task.jsf.MyFacesJsfLibrarySetup.MYFACES_IMPL_ARTIFACT_ID;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.galleon.ProvisioningException;
import org.wildfly.prospero.api.MavenOptions;
import org.wildfly.prospero.wfchannel.MavenSessionManager;

public class MavenUtils {

    public static final String MAVEN_REPO_PATH = System.getProperty("maven.repo.path");

    public static final String CENTRAL_REPOSITORY_URL = "https://repo1.maven.org/maven2/";

    public static void deployMyFacesArtifactsLocally(String version, String repositoryUrl, String localRepositoryUrl) throws ProvisioningException, ArtifactResolutionException, DeploymentException {
        Path localRepoPath;
        if (MAVEN_REPO_PATH != null) {
            localRepoPath = Paths.get(MAVEN_REPO_PATH);
        } else {
            localRepoPath = determineLocalRepository();
        }

        System.out.println("localRepoPath set to : " + localRepoPath);
        final MavenSessionManager msm = new MavenSessionManager(MavenOptions.builder()
                .setLocalCachePath(localRepoPath)
                .build());
        final RepositorySystem system = msm.newRepositorySystem();
        final DefaultRepositorySystemSession session = msm.newRepositorySystemSession(system);
        final DefaultArtifact apiArtifact = new DefaultArtifact(MYFACES_GROUP_ID + ":" + MYFACES_API_ARTIFACT_ID + ":" + version);
        final DefaultArtifact implArtifact = new DefaultArtifact(MYFACES_GROUP_ID + ":" + MYFACES_IMPL_ARTIFACT_ID + ":" + version);
        final RemoteRepository centralRepository = new RemoteRepository.Builder("central", "default", repositoryUrl).build();
        final List<ArtifactResult> artifactResults = system.resolveArtifacts(session, List.of(
                new ArtifactRequest(apiArtifact, List.of(centralRepository), null),
                new ArtifactRequest(implArtifact, List.of(centralRepository), null)
        ));
        final DeployRequest deployRequest = new DeployRequest();
        deployRequest.setRepository(new RemoteRepository.Builder("jsf-repo", "default", localRepositoryUrl).build());
        deployRequest.addArtifact(artifactResults.get(0).getArtifact());
        deployRequest.addArtifact(artifactResults.get(1).getArtifact());
        system.deploy(session, deployRequest);
    }
}
