/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

import org.jboss.installer.auto.AutomaticInstallationParsingException;
import org.jboss.installer.core.FlatListPostInstallConfig;

public class CredentialStoreConfig extends FlatListPostInstallConfig {

    private String storeName;
    private String relativeTo;
    private String path;
    private String password;

    public CredentialStoreConfig() {

    }

    public CredentialStoreConfig(String storeName, String relativeTo, String path, String password) {
        this.storeName = storeName;
        this.relativeTo = relativeTo;
        this.path = path;
        this.password = password;
    }

    public String getStoreName() {
        return storeName;
    }

    public String getRelativeTo() {
        return relativeTo;
    }

    public String getPath() {
        return path;
    }

    public String getPassword() {
        return password;
    }

    @Override
    protected Map<String, String> listAttributes() {
        final HashMap<String, String> attrs = new HashMap<>();
        attrs.put("storeName", storeName);
        attrs.put("relativeTo", relativeTo);
        attrs.put("path", path);
        return attrs;
    }

    @Override
    protected Set<String> listVariables() {
        final HashSet<String> vars = new HashSet<>();
        vars.add("credential-store.password");
        return vars;
    }

    @Override
    protected void acceptAttributes(Map<String, String> attributes, BiFunction<String, String, String> variableResolver) throws AutomaticInstallationParsingException {
        this.storeName = attributes.get("storeName");
        this.relativeTo = attributes.get("relativeTo");
        this.path = attributes.get("path");
        this.password = variableResolver.apply("credential-store.password", "Credential store password:");
    }
}
