/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.validators;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.ValidationResult;

import java.util.regex.Pattern;

public class AdminLoginValidator extends PasswordEqualityValidator {

    public static final String EMPTY_USERNAME_KEY = "admin_creation_screen.empty_username";
    public static final String NON_ALPHANUMERIC_USERNAME_KEY = "admin_creation_screen.alphanumeric";
    public static final String EMPTY_PASSWORD_KEY = "admin_creation_screen.empty_password";
    public static final String CONFIRMATION_PASSWORD_MATCH_KEY = "admin_creation_screen.confirmation_password_match";
    public static Pattern usernamePattern = Pattern.compile("^[a-zA-Z0-9@,./=\\\\]*$");

    public AdminLoginValidator(LanguageUtils langUtils) {
        super(langUtils);
    }

    public ValidationResult validate(String username, String password, String confirmPassword) {
        if (username.length() == 0) {
            return ValidationResult.error(langUtils.getString(EMPTY_USERNAME_KEY));
        }
        if (!usernamePattern.matcher(username).matches()) {
            return ValidationResult.error(langUtils.getString(NON_ALPHANUMERIC_USERNAME_KEY));
        }

        return super.validate(password, confirmPassword, null);
    }
}
