/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.actions.impl;

import java.beans.PropertyChangeSupport;
import java.nio.file.Path;
import java.util.Collections;

import org.assertj.core.api.Assertions;
import org.jboss.installer.core.BuildProperties;
import org.jboss.installer.test.utils.MockLanguageUtils;
import org.jboss.installer.test.utils.TestProperties;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.prospero.metadata.ProsperoMetadataUtils;

public class InstallEapTest {

    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void installedServerUsesProfileChannelName() throws Exception {
        final Path target = tempFolder.newFolder().toPath();
        final InstallEap installer = new InstallEap(target, evt -> {
            // do nothing
        }, Collections.emptyList(), TestProperties.getTestRepositories(), new MockLanguageUtils());

        installer.perform(new PropertyChangeSupport(new Object()));

        final Channel channel = ChannelMapper.from(target.resolve(ProsperoMetadataUtils.METADATA_DIR)
                .resolve(ProsperoMetadataUtils.INSTALLER_CHANNELS_FILE_NAME).toUri().toURL());

        Assertions.assertThat(channel.getName())
                // assume that the channel name is the same as the profile, at least for EAP 8
                .isEqualTo(BuildProperties.PROSPERO_INSTALLATION_PROFILE);
    }

}