package org.jboss.installer.auto;

import org.apache.commons.io.FileUtils;
import org.junit.Test;

import static org.junit.Assert.assertTrue;

public class MinimalInstallationTest extends BaseAutomaticInstallationTest {

    @Test
    public void testMinimalInstallation() throws Exception {
        automaticInstallation.performInstallation(installationData);

        assertTrue(testDir.resolve("standalone").toFile().exists());
        assertTrue(FileUtils.readFileToString(testDir
                        .resolve("standalone")
                        .resolve("configuration")
                        .resolve("mgmt-users.properties")
                        .toFile(), "UTF-8")
                .contains("testName"));
    }
}
