/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.vocab.frequency;

import com.sun.xml.analysis.frequency.FrequencyBasedLists;
import com.sun.xml.analysis.frequency.FrequencyHandler;
import com.sun.xml.analysis.frequency.SchemaProcessor;
import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.tools.PrintTable;
import com.sun.xml.fastinfoset.util.CharArrayIntMap;
import com.sun.xml.fastinfoset.util.ContiguousCharArrayArray;
import com.sun.xml.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.fastinfoset.util.PrefixArray;
import com.sun.xml.fastinfoset.util.QualifiedNameArray;
import com.sun.xml.fastinfoset.util.StringArray;
import com.sun.xml.fastinfoset.util.StringIntMap;
import com.sun.xml.fastinfoset.vocab.ParserVocabulary;
import com.sun.xml.fastinfoset.vocab.SerializerVocabulary;
import java.io.File;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jvnet.fastinfoset.Vocabulary;
import org.xml.sax.helpers.DefaultHandler;

public class VocabularyGenerator {
    private XmlApi _xapi;
    private SerializerVocabulary _serializerVocabulary;
    private ParserVocabulary _parserVocabulary;

    public VocabularyGenerator(FrequencyBasedLists fbl, XmlApi xapi) {
        this(new SerializerVocabulary(), new ParserVocabulary(), fbl, xapi);
    }

    public VocabularyGenerator(SerializerVocabulary serializerVocabulary, ParserVocabulary parserVocabulary, FrequencyBasedLists fbl, XmlApi xapi) {
        this._serializerVocabulary = serializerVocabulary;
        this._parserVocabulary = parserVocabulary;
        this._xapi = xapi;
        this.generate(fbl);
    }

    public SerializerVocabulary getSerializerVocabulary() {
        return this._serializerVocabulary;
    }

    public ParserVocabulary getParserVocabulary() {
        return this._parserVocabulary;
    }

    private void generate(FrequencyBasedLists fbl) {
        for (String prefix : fbl.prefixes) {
            this.addToTable(prefix, this._serializerVocabulary.prefix, this._parserVocabulary.prefix);
        }
        for (String namespace : fbl.namespaces) {
            this.addToTable(namespace, this._serializerVocabulary.namespaceName, this._parserVocabulary.namespaceName);
        }
        for (String localName : fbl.localNames) {
            this.addToTable(localName, this._serializerVocabulary.localName, this._parserVocabulary.localName);
        }
        for (QName element : fbl.elements) {
            this.addToNameTable(element, this._serializerVocabulary.elementName, this._parserVocabulary.elementName, false);
        }
        for (QName attribute : fbl.attributes) {
            this.addToNameTable(attribute, this._serializerVocabulary.attributeName, this._parserVocabulary.attributeName, true);
        }
        for (String textContentValue : fbl.textContentValues) {
            this.addToTable(textContentValue, this._serializerVocabulary.characterContentChunk, this._parserVocabulary.characterContentChunk);
        }
        for (String attributeValue : fbl.attributeValues) {
            this.addToTable(attributeValue, this._serializerVocabulary.attributeValue, this._parserVocabulary.attributeValue);
        }
    }

    private void addToNameTable(QName n, LocalNameQualifiedNamesMap m, QualifiedNameArray a, boolean isAttribute) {
        int localNameIndex;
        int namespaceURIIndex = -1;
        int prefixIndex = -1;
        if (n.getNamespaceURI().length() > 0) {
            namespaceURIIndex = this._serializerVocabulary.namespaceName.obtainIndex(n.getNamespaceURI());
            if (namespaceURIIndex == -1) {
                namespaceURIIndex = this._serializerVocabulary.namespaceName.get(n.getNamespaceURI());
                this._parserVocabulary.namespaceName.add(n.getNamespaceURI());
            }
            if (n.getPrefix().length() > 0 && (prefixIndex = this._serializerVocabulary.prefix.obtainIndex(n.getPrefix())) == -1) {
                prefixIndex = this._serializerVocabulary.prefix.get(n.getPrefix());
                this._parserVocabulary.prefix.add(n.getPrefix());
            }
        }
        if ((localNameIndex = this._serializerVocabulary.localName.obtainIndex(n.getLocalPart())) == -1) {
            localNameIndex = this._serializerVocabulary.localName.get(n.getLocalPart());
            this._parserVocabulary.localName.add(n.getLocalPart());
        }
        QualifiedName name = new QualifiedName(n.getPrefix(), n.getNamespaceURI(), n.getLocalPart(), m.getNextIndex(), prefixIndex, namespaceURIIndex, localNameIndex);
        if (isAttribute) {
            name.createAttributeValues(256);
        }
        LocalNameQualifiedNamesMap.Entry entry = null;
        if (this._xapi == XmlApi.StAX) {
            entry = m.obtainEntry(n.getLocalPart());
        } else {
            String qName = prefixIndex == -1 ? n.getLocalPart() : n.getPrefix() + ":" + n.getLocalPart();
            entry = m.obtainEntry(qName);
        }
        entry.addQualifiedName(name);
        a.add(name);
    }

    private void addToTable(String s, StringIntMap m, StringArray a) {
        if (s.length() == 0) {
            return;
        }
        m.obtainIndex(s);
        a.add(s);
    }

    private void addToTable(String s, StringIntMap m, PrefixArray a) {
        if (s.length() == 0) {
            return;
        }
        m.obtainIndex(s);
        a.add(s);
    }

    private void addToTable(String s, CharArrayIntMap m, ContiguousCharArrayArray a) {
        if (s.length() == 0) {
            return;
        }
        char[] c = s.toCharArray();
        m.obtainIndex(c, 0, c.length, false);
        a.add(c, c.length);
    }

    public static void main(String[] args) throws Exception {
        SchemaProcessor sp = new SchemaProcessor(new File(args[0]).toURL(), true, false);
        sp.process();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser p = spf.newSAXParser();
        FrequencyHandler fh = new FrequencyHandler(sp);
        for (int i = 1; i < args.length; ++i) {
            p.parse(new File(args[i]), (DefaultHandler)fh);
        }
        VocabularyGenerator vg = new VocabularyGenerator(fh.getLists(), XmlApi.SAX);
        PrintTable.printVocabulary((ParserVocabulary)vg.getParserVocabulary());
        Vocabulary v = fh.getVocabulary();
        ParserVocabulary pv = new ParserVocabulary(v);
        System.out.println("");
        PrintTable.printVocabulary((ParserVocabulary)pv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum XmlApi {
        SAX,
        StAX,
        DOM;

    }
}

