/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jboss.virtual.VirtualFile;
import org.xml.sax.InputSource;

public class VFSInputSource
extends InputSource {
    private VirtualFile file;

    public VFSInputSource(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    public String getSystemId() {
        try {
            return this.file.toURI().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getByteStream() {
        try {
            return this.file.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Reader getCharacterStream() {
        return new InputStreamReader(this.getByteStream());
    }

    public String toString() {
        return this.file.getPathName();
    }
}

