/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.Util;
import org.jboss.util.StringPropertyReplacer;

public class RoleMappingLoginModule
extends AbstractServerLoginModule {
    private static Logger log = Logger.getLogger(RoleMappingLoginModule.class);
    private boolean trace = log.isTraceEnabled();
    protected boolean REPLACE_ROLE = false;

    public boolean login() throws LoginException {
        if (super.login()) {
            return true;
        }
        this.loginOk = true;
        return true;
    }

    protected Principal getIdentity() {
        for (Principal p : this.subject.getPrincipals()) {
            if (p instanceof Group) continue;
            return p;
        }
        return null;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group group;
        block9: {
            String propFileName;
            String rep = (String)this.options.get("replaceRole");
            if ("true".equalsIgnoreCase(rep)) {
                this.REPLACE_ROLE = true;
            }
            if ((propFileName = (String)this.options.get("rolesProperties")) == null) {
                throw new IllegalStateException("rolesProperties option needs to be provided");
            }
            propFileName = StringPropertyReplacer.replaceProperties((String)propFileName);
            group = this.getExistingRolesFromSubject();
            if (propFileName != null) {
                Properties props;
                block8: {
                    props = new Properties();
                    try {
                        props = Util.loadProperties(propFileName, log);
                    }
                    catch (Exception e) {
                        if (!this.trace) break block8;
                        log.trace((Object)("Could not load properties file:" + propFileName), (Throwable)e);
                    }
                }
                if (props != null) {
                    try {
                        this.processRoles(group, props);
                    }
                    catch (Exception e) {
                        if (!this.trace) break block9;
                        log.trace((Object)"Could not process roles:", (Throwable)e);
                    }
                }
            }
        }
        return new Group[]{group};
    }

    private Group getExistingRolesFromSubject() {
        for (Principal p : this.subject.getPrincipals()) {
            Group g;
            if (!(p instanceof Group) || !"Roles".equals((g = (Group)p).getName())) continue;
            return g;
        }
        return null;
    }

    private void processRoles(Group group, Properties props) throws Exception {
        Enumeration<?> enumer = props.propertyNames();
        while (enumer.hasMoreElements()) {
            String roleKey = (String)enumer.nextElement();
            String comma_separated_roles = props.getProperty(roleKey);
            Principal pIdentity = this.createIdentity(roleKey);
            if (group.isMember(pIdentity)) {
                Util.parseGroupMembers(group, comma_separated_roles, this);
            }
            if (!this.REPLACE_ROLE) continue;
            group.removeMember(pIdentity);
        }
    }
}

