/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.QueryParameterException;
import org.hibernate.SQLQuery;
import org.hibernate.TypeMismatchException;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.HibernateQuery;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.hql.QueryExecutionRequestException;
import org.hibernate.impl.AbstractQueryImpl;

public class QueryImpl
implements javax.persistence.Query,
HibernateQuery {
    private Query query;
    private HibernateEntityManagerImplementor em;
    private Boolean isPositional = null;
    private int maxResults = -1;

    public QueryImpl(Query query, AbstractEntityManagerImpl em) {
        this.query = query;
        this.em = em;
    }

    public Query getHibernateQuery() {
        return this.query;
    }

    public int executeUpdate() {
        try {
            if (!this.em.isTransactionInProgress()) {
                this.em.throwPersistenceException((PersistenceException)new TransactionRequiredException("Executing an update/delete query"));
                return 0;
            }
            return this.query.executeUpdate();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return 0;
        }
    }

    public List getResultList() {
        try {
            return this.query.list();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getSingleResult() {
        try {
            List result;
            if (this.query instanceof AbstractQueryImpl) {
                if (this.maxResults != 1 && !SQLQuery.class.isAssignableFrom(this.query.getClass())) {
                    this.query.setMaxResults(2);
                }
                result = this.query.list();
                if (this.maxResults != -1) {
                    this.query.setMaxResults(this.maxResults);
                } else {
                    AbstractQueryImpl queryImpl = (AbstractQueryImpl)AbstractQueryImpl.class.cast(this.query);
                    queryImpl.getSelection().setMaxRows(null);
                }
            } else {
                result = this.query.list();
            }
            if (result.size() == 0) {
                this.em.throwPersistenceException((PersistenceException)new NoResultException("No entity found for query"));
                return null;
            } else {
                if (result.size() <= 1) return result.get(0);
                HashSet uniqueResult = new HashSet(result);
                if (uniqueResult.size() <= 1) return uniqueResult.iterator().next();
                this.em.throwPersistenceException((PersistenceException)new NonUniqueResultException("result returns more than one elements"));
            }
            return null;
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setMaxResults(int maxResult) {
        if (maxResult < 0) {
            throw new IllegalArgumentException("Negative (" + maxResult + ") parameter passed in to setMaxResults");
        }
        this.maxResults = maxResult;
        this.query.setMaxResults(maxResult);
        return this;
    }

    public javax.persistence.Query setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("Negative (" + firstResult + ") parameter passed in to setFirstResult");
        }
        this.query.setFirstResult(firstResult);
        return this;
    }

    public javax.persistence.Query setHint(String hintName, Object value) {
        try {
            if ("org.hibernate.timeout".equals(hintName)) {
                this.query.setTimeout(ConfigurationHelper.getInteger(value).intValue());
            } else if ("org.hibernate.comment".equals(hintName)) {
                this.query.setComment((String)value);
            } else if ("org.hibernate.fetchSize".equals(hintName)) {
                this.query.setFetchSize(ConfigurationHelper.getInteger(value).intValue());
            } else if ("org.hibernate.cacheRegion".equals(hintName)) {
                this.query.setCacheRegion((String)value);
            } else if ("org.hibernate.cacheable".equals(hintName)) {
                this.query.setCacheable(ConfigurationHelper.getBoolean(value).booleanValue());
            } else if ("org.hibernate.readOnly".equals(hintName)) {
                this.query.setReadOnly(ConfigurationHelper.getBoolean(value).booleanValue());
            } else if ("org.hibernate.cacheMode".equals(hintName)) {
                this.query.setCacheMode(ConfigurationHelper.getCacheMode(value));
            } else if ("org.hibernate.flushMode".equals(hintName)) {
                this.query.setFlushMode(ConfigurationHelper.getFlushMode(value));
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for hint");
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Object value) {
        try {
            if (value instanceof Collection) {
                this.query.setParameterList(name, (Collection)value);
            } else {
                this.query.setParameter(name, value);
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setParameter(String name, Date value, TemporalType temporalType) {
        try {
            if (temporalType == TemporalType.DATE) {
                this.query.setDate(name, value);
            } else if (temporalType == TemporalType.TIME) {
                this.query.setTime(name, value);
            } else if (temporalType == TemporalType.TIMESTAMP) {
                this.query.setTimestamp(name, value);
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setParameter(String name, Calendar value, TemporalType temporalType) {
        try {
            if (temporalType == TemporalType.DATE) {
                this.query.setCalendarDate(name, value);
            } else {
                if (temporalType == TemporalType.TIME) {
                    throw new IllegalArgumentException("not yet implemented");
                }
                if (temporalType == TemporalType.TIMESTAMP) {
                    this.query.setCalendar(name, value);
                }
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setParameter(int position, Object value) {
        try {
            if (this.isPositionalParameter()) {
                this.setParameter(Integer.toString(position), value);
            } else {
                this.query.setParameter(position - 1, value);
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    private boolean isPositionalParameter() {
        if (this.isPositional == null) {
            String queryString = this.query.getQueryString();
            int index = queryString.indexOf(63);
            this.isPositional = index == -1 ? Boolean.valueOf(true) : (index == queryString.length() - 1 ? Boolean.valueOf(false) : Boolean.valueOf(Character.isDigit(queryString.charAt(index + 1))));
        }
        return this.isPositional;
    }

    public javax.persistence.Query setParameter(int position, Date value, TemporalType temporalType) {
        try {
            if (this.isPositionalParameter()) {
                String name = Integer.toString(position);
                this.setParameter(name, value, temporalType);
            } else if (temporalType == TemporalType.DATE) {
                this.query.setDate(position - 1, value);
            } else if (temporalType == TemporalType.TIME) {
                this.query.setTime(position - 1, value);
            } else if (temporalType == TemporalType.TIMESTAMP) {
                this.query.setTimestamp(position - 1, value);
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setParameter(int position, Calendar value, TemporalType temporalType) {
        try {
            if (this.isPositionalParameter()) {
                String name = Integer.toString(position);
                this.setParameter(name, value, temporalType);
            } else if (temporalType == TemporalType.DATE) {
                this.query.setCalendarDate(position - 1, value);
            } else {
                if (temporalType == TemporalType.TIME) {
                    throw new IllegalArgumentException("not yet implemented");
                }
                if (temporalType == TemporalType.TIMESTAMP) {
                    this.query.setCalendar(position - 1, value);
                }
            }
            return this;
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            this.em.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.query.setFlushMode(FlushMode.AUTO);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.query.setFlushMode(FlushMode.COMMIT);
        }
        return this;
    }
}

