/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import javassist.CtClass;
import org.jboss.aop.classpool.AbstractClassPoolDomain;
import org.jboss.aop.classpool.ClassPoolDomain;
import org.jboss.aop.classpool.ClassPoolToClassPoolDomainAdaptorFactory;
import org.jboss.aop.classpool.DelegatingClassPool;
import org.jboss.aop.classpool.ParentDelegationStrategy;
import org.jboss.logging.Logger;

public abstract class AbstractParentDelegationStrategy
implements ParentDelegationStrategy {
    protected final Logger logger = Logger.getLogger((String)this.getClass().getName());
    private AbstractClassPoolDomain domain;
    private AbstractClassPoolDomain parent;

    protected AbstractParentDelegationStrategy(ClassPoolDomain parent, ClassPoolToClassPoolDomainAdaptorFactory adaptorFactory) {
        if (parent == null) {
            if (adaptorFactory == null) {
                throw new IllegalStateException("Null parent and null adaptorFactory");
            }
            this.parent = adaptorFactory.createAdaptor();
        } else {
            if (!(parent instanceof AbstractClassPoolDomain)) {
                throw new IllegalArgumentException("Parent must implement AbstractClassPoolDomain");
            }
            this.parent = (AbstractClassPoolDomain)parent;
        }
        if (this.parent == null) {
            throw new IllegalStateException("Parent was not set");
        }
    }

    protected boolean hasParent() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this + " " + this.getDomain() + " hasParent " + this.parent != null ? 1 : 0));
        }
        return this.parent != null;
    }

    protected AbstractClassPoolDomain getDomain() {
        return this.domain;
    }

    public CtClass getCachedOrCreateFromParent(DelegatingClassPool initiatingPool, String classname, String resourceName, boolean create, boolean trace) {
        return this.parent.getCachedOrCreate(initiatingPool, classname, resourceName, create, trace);
    }

    public void setDomain(AbstractClassPoolDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Null domain");
        }
        if (this.domain != null) {
            throw new IllegalArgumentException("Cannot change domain");
        }
        this.domain = domain;
    }
}

