/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.coyote;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ServerSocketFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.SocketStatus;
import org.jboss.logging.Logger;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.transport.coyote.ClientAbortException;
import org.jboss.remoting.transport.coyote.RequestMap;
import org.jboss.remoting.transport.coyote.ResponseMap;
import org.jboss.remoting.transport.coyote.ssl.RemotingSSLImplementation;
import org.jboss.remoting.transport.coyote.ssl.RemotingServerSocketFactory;
import org.jboss.remoting.transport.web.WebServerInvoker;
import org.jboss.remoting.transport.web.WebUtil;
import org.jboss.remoting.util.SecurityUtility;

public class CoyoteInvoker
extends WebServerInvoker
implements Adapter {
    private static final Logger log = Logger.getLogger(CoyoteInvoker.class);
    protected static ThreadLocal receivedInvocationRequest = new ThreadLocal();
    protected static final Boolean FALSE = new Boolean(false);
    protected static final Boolean TRUE = new Boolean(true);
    private boolean running = false;
    protected List protocolHandlers = new ArrayList();
    protected String URIEncoding = null;
    protected String useRemotingContentType = "false";

    public CoyoteInvoker(InvokerLocator locator) {
        super(locator);
    }

    public CoyoteInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected void setup() throws Exception {
        super.setup();
        Map config = this.getConfiguration();
        boolean apr = false;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String methodName = "initialize";
                    Class[] paramTypes = new Class[]{String.class};
                    Object[] paramValues = new Object[]{null};
                    String className = "org.apache.tomcat.jni.Library";
                    Method method = Class.forName(className).getMethod(methodName, paramTypes);
                    method.invoke(null, paramValues);
                    return null;
                }
            });
            apr = true;
        }
        catch (PrivilegedActionException e) {
            log.trace((Object)"", e.getCause());
        }
        String protocolHandlerClassName = null;
        Object value = config.get("protocolHandlerClassName");
        protocolHandlerClassName = value != null ? String.valueOf(value) : (apr ? "org.apache.coyote.http11.Http11AprProtocol" : "org.apache.coyote.http11.Http11Protocol");
        log.info((Object)("Using " + protocolHandlerClassName + " for http (coyote) invoker protocol handler."));
        Class clazz = null;
        try {
            clazz = (Class)CoyoteInvoker.forName(protocolHandlerClassName);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Protocol handler class instatiation failed: protocolHandlerClassName", (Throwable)e);
            return;
        }
        ProtocolHandler protocolHandler = null;
        for (int i = 0; i < this.connectHomes.size(); ++i) {
            try {
                protocolHandler = (ProtocolHandler)clazz.newInstance();
            }
            catch (Exception e) {
                log.error((Object)"Protocol handler instantiation failed", (Throwable)e);
                return;
            }
            protocolHandler.setAdapter((Adapter)this);
            for (String key : config.keySet()) {
                Object obj = config.get(key);
                if (!(obj instanceof String)) continue;
                String val = (String)obj;
                CoyoteInvoker.setProperty(protocolHandler, key, val);
            }
            String timeoutValue = (String)config.get("timeout");
            if (timeoutValue != null) {
                CoyoteInvoker.setProperty(protocolHandler, "connectionTimeout", timeoutValue);
            }
            if ((value = config.get("URIEncoding")) != null) {
                this.URIEncoding = String.valueOf(value);
            }
            this.protocolHandlers.add(protocolHandler);
            value = config.get("useRemotingContentType");
            if (value instanceof String) {
                this.useRemotingContentType = (String)value;
            } else if (value != null) {
                log.warn((Object)("useRemotingContentType value should be a String: " + value));
            }
            log.debug((Object)(this + " useRemotingContentType: " + this.useRemotingContentType));
        }
    }

    protected ServerSocketFactory getDefaultServerSocketFactory() throws IOException {
        if ("https".equals(this.locator.getProtocol())) {
            SSLSocketBuilder builder = new SSLSocketBuilder(this.configuration);
            builder.setUseSSLServerSocketFactory(false);
            try {
                return builder.createSSLServerSocketFactory();
            }
            catch (IOException e) {
                log.debug((Object)"unable to create server socket factory", (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    public void start() throws IOException {
        if (!this.running) {
            for (int i = 0; i < this.protocolHandlers.size(); ++i) {
                try {
                    final ProtocolHandler protocolHandler = (ProtocolHandler)this.protocolHandlers.get(i);
                    Home home = (Home)this.getHomes().get(i);
                    CoyoteInvoker.setProperty(protocolHandler, "address", home.host);
                    CoyoteInvoker.setProperty(protocolHandler, "port", "" + home.port);
                    CoyoteInvoker.setProperty(protocolHandler, "locator", this.getLocator().getLocatorURI());
                    RemotingSSLImplementation.setMBeanServer(this.getLocator().getLocatorURI(), this.getMBeanServer());
                    ServerSocketFactory svrSocketFactory = this.getServerSocketFactory();
                    if (svrSocketFactory != null) {
                        RemotingServerSocketFactory.setServerSocketFactory(this.getLocator().getLocatorURI(), svrSocketFactory);
                        CoyoteInvoker.setProperty(protocolHandler, "SocketFactory", RemotingServerSocketFactory.class.getName());
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                protocolHandler.init();
                                protocolHandler.start();
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (Exception)e.getCause();
                    }
                    this.running = true;
                    continue;
                }
                catch (Exception e) {
                    log.debug((Object)("Error starting protocol handler.  Bind port: " + this.getServerBindPort() + ", bind address: " + this.getServerBindAddress()), (Throwable)e);
                    throw new IOException("" + e.getMessage());
                }
            }
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response res) throws Exception {
        block26: {
            RequestMap request = (RequestMap)req.getNote(1);
            ResponseMap response = (ResponseMap)res.getNote(1);
            if (request == null) {
                request = new RequestMap();
                request.setCoyoteRequest(req);
                response = new ResponseMap();
                response.setCoyoteResponse(res);
                req.setNote(1, (Object)request);
                res.setNote(1, (Object)response);
            } else {
                response.clear();
                request.clear();
            }
            try {
                try {
                    if (this.postParseRequest(req, request, res, response)) {
                        int status;
                        MessageBytes remoteAddressMB;
                        InvocationRequest invocationRequest;
                        this.populateRequestMetadata(request, req);
                        Object responseObject = null;
                        boolean isError = false;
                        int version = this.getVersion(request);
                        boolean isRemotingUserAgent = false;
                        Object userAgentObj = request.get("User-Agent");
                        if (userAgentObj != null) {
                            String userAgent = (String)userAgentObj;
                            isRemotingUserAgent = userAgent.startsWith("JBossRemoting");
                        }
                        if ((invocationRequest = this.versionedRead(req, request, response, version)).getRequestPayload() == null) {
                            invocationRequest.setRequestPayload(new HashMap());
                        }
                        if ((remoteAddressMB = req.remoteAddr()) != null) {
                            String remoteAddressString = remoteAddressMB.toString();
                            InetAddress remoteAddress = CoyoteInvoker.getAddressByName(remoteAddressString);
                            invocationRequest.getRequestPayload().put("clientAddress", remoteAddress);
                        } else {
                            log.debug((Object)"unable to retrieve client address from coyote transport layer");
                        }
                        try {
                            responseObject = this.invoke(invocationRequest);
                        }
                        catch (Throwable ex) {
                            log.debug((Object)"Error thrown calling invoke on server invoker.", ex);
                            responseObject = ex;
                            isError = true;
                        }
                        String message = "";
                        if (responseObject != null) {
                            if (isError) {
                                status = 500;
                                message = "JBoss Remoting: Error occurred within target application.";
                            } else {
                                status = 200;
                                message = "OK";
                            }
                        } else if (isRemotingUserAgent && !req.method().equals("HEAD")) {
                            status = 200;
                            message = "OK";
                        } else {
                            status = 204;
                            message = "No Content";
                        }
                        Map responseMap = invocationRequest.getReturnPayload();
                        if (responseMap != null) {
                            String handlerMessage;
                            Integer handlerStatus = (Integer)responseMap.get("ResponseCode");
                            if (handlerStatus != null) {
                                status = handlerStatus;
                            }
                            if ((handlerMessage = (String)responseMap.get("ResponseCodeMessage")) != null) {
                                message = handlerMessage;
                            }
                        }
                        res.setStatus(status);
                        res.setMessage(message);
                        if (isRemotingUserAgent && ((Boolean)receivedInvocationRequest.get()).booleanValue()) {
                            responseMap = ((ResponseMap)responseMap).getMap();
                            responseObject = new InvocationResponse(invocationRequest.getSessionId(), responseObject, isError, responseMap);
                        }
                        if (responseObject != null) {
                            this.versionedWrite(version, responseObject, req, res, response);
                        }
                    }
                    response.outputBuffer.close();
                    req.action(ActionCode.ACTION_POST_REQUEST, null);
                }
                catch (ClientAbortException e) {
                    log.debug((Object)"Client didn't wait", (Throwable)e);
                    Object var18_23 = null;
                    request.recycle();
                    response.recycle();
                    break block26;
                }
                catch (IOException e) {
                    log.error((Object)"Error processing request", (Throwable)e);
                    Object var18_24 = null;
                    request.recycle();
                    response.recycle();
                    break block26;
                }
                catch (Throwable t) {
                    log.error((Object)"Service error", t);
                    Object var18_25 = null;
                    request.recycle();
                    response.recycle();
                }
                Object var18_22 = null;
                request.recycle();
                response.recycle();
            }
            catch (Throwable throwable) {
                Object var18_26 = null;
                request.recycle();
                response.recycle();
                throw throwable;
            }
        }
    }

    private void addLeaseInfo(ResponseMap response) {
        boolean leaseManagement = this.isLeaseActivated();
        response.put("LEASING_ENABLED", new Boolean(leaseManagement));
        if (leaseManagement) {
            long leasePeriod = this.getLeasePeriod();
            response.put("LEASE_PERIOD", new Long(leasePeriod));
        }
    }

    private void versionedWrite(int version, Object responseObject, Request req, Response res, ResponseMap response) throws IOException {
        switch (version) {
            case 1: 
            case 2: 
            case 22: {
                String responseContentType = (String)response.get("Content-Type");
                if (responseContentType != null) {
                    if (CoyoteInvoker.isInvalidContentType(responseContentType)) {
                        log.warn((Object)("Ignoring invalid content-type from ServerInvocationHandler: " + responseContentType));
                        if (responseObject == null) {
                            responseContentType = req.getContentType();
                            if (CoyoteInvoker.isInvalidContentType(responseContentType)) {
                                log.warn((Object)("Ignoring invalid content-type from request: " + responseContentType));
                                responseContentType = WebUtil.getContentType(responseObject);
                            }
                        } else {
                            responseContentType = WebUtil.getContentType(responseObject);
                        }
                    }
                } else if (responseObject == null) {
                    responseContentType = req.getContentType();
                    if (CoyoteInvoker.isInvalidContentType(responseContentType)) {
                        log.warn((Object)("Ignoring invalid content-type from request: " + responseContentType));
                        responseContentType = WebUtil.getContentType(responseObject);
                    }
                } else {
                    responseContentType = WebUtil.getContentType(responseObject);
                }
                res.setContentType(responseContentType);
                if (responseObject instanceof String) {
                    res.addHeader("remotingContentType", "remotingContentTypeString");
                } else {
                    res.addHeader("remotingContentType", "remotingContentTypeNonString");
                }
                Marshaller marshaller = this.getMarshaller();
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(responseObject, response.getOutputStream(), version);
                } else {
                    marshaller.write(responseObject, response.getOutputStream());
                }
                return;
            }
        }
        throw new IOException("Can not send response due to version (" + version + ") not being supported.  Supported versions: " + 1 + ", " + 2 + ", " + 22);
    }

    private InvocationRequest versionedRead(Request req, RequestMap request, ResponseMap response, int version) throws IOException, ClassNotFoundException {
        switch (version) {
            case 1: 
            case 2: 
            case 22: {
                Object o = this.configuration.get("preserveLines");
                if (o != null) {
                    request.put("preserveLines", o);
                }
                receivedInvocationRequest.set(FALSE);
                InvocationRequest invocationRequest = null;
                MessageBytes method = req.method();
                if (method.equals("GET") || method.equals("HEAD") || method.equals("OPTIONS") && req.getContentLength() <= 0) {
                    invocationRequest = this.createNewInvocationRequest(request, response, null);
                } else {
                    UnMarshaller unmarshaller = this.getUnMarshaller();
                    request.put("useRemotingContentType", this.useRemotingContentType);
                    Object obj = null;
                    obj = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read(request.getInputStream(), request, version) : unmarshaller.read(request.getInputStream(), request);
                    if (obj instanceof InvocationRequest) {
                        Map requestPayloadMap;
                        receivedInvocationRequest.set(TRUE);
                        invocationRequest = (InvocationRequest)obj;
                        if (invocationRequest.getReturnPayload() == null) {
                            invocationRequest.setReturnPayload(response);
                        }
                        if ((requestPayloadMap = invocationRequest.getRequestPayload()) != null) {
                            request.putAll(requestPayloadMap);
                        }
                        invocationRequest.setRequestPayload(request);
                    } else {
                        invocationRequest = this.createNewInvocationRequest(request, response, obj);
                    }
                }
                return invocationRequest;
            }
        }
        throw new IOException("Can not processes request due to incorrect version (" + version + ").  Can only process versions: " + 1 + ", " + 2 + ", " + 22);
    }

    private int getVersion(RequestMap request) {
        int version = 1;
        Object versionObj = request.get("JBoss-Remoting-Version");
        if (versionObj != null) {
            String versionString = (String)versionObj;
            try {
                version = Integer.parseInt(versionString);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Can not processes remoting version of " + versionString + " as is not a number."));
            }
        }
        return version;
    }

    private void populateRequestMetadata(RequestMap metadata, Request req) {
        final MimeHeaders headers = req.getMimeHeaders();
        Enumeration nameEnum = null;
        nameEnum = SecurityUtility.skipAccessControl() ? headers.names() : (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return headers.names();
            }
        });
        while (nameEnum.hasMoreElements()) {
            Object nameObj = nameEnum.nextElement();
            if (!(nameObj instanceof String)) continue;
            String valueObj = headers.getHeader((String)nameObj);
            metadata.put(nameObj, valueObj);
        }
        metadata.put("MethodType", req.method().getString());
        metadata.put("Path", req.requestURI().getString());
        metadata.put("Query", req.query().toString());
        metadata.put("HttpVersion", req.protocol().getString());
    }

    protected InvocationRequest createNewInvocationRequest(RequestMap requestMap, ResponseMap responseMap, Object payload) {
        String sessionId = this.getSessionId(requestMap);
        String subSystem = (String)requestMap.get(HEADER_SUBSYSTEM);
        InvocationRequest request = null;
        boolean isLeaseQueury = this.checkForLeaseQuery(requestMap);
        if (isLeaseQueury) {
            this.addLeaseInfo(responseMap);
            request = new InvocationRequest(sessionId, subSystem, "$PING$", null, responseMap, null);
        } else {
            request = new InvocationRequest(sessionId, subSystem, payload, requestMap, responseMap, null);
        }
        return request;
    }

    private boolean checkForLeaseQuery(RequestMap headers) {
        Object val;
        boolean isLeaseQuery = false;
        if (headers != null && (val = headers.get("JBoss-Remoting-Lease-Query")) != null && val instanceof String) {
            isLeaseQuery = Boolean.valueOf((String)val);
        }
        return isLeaseQuery;
    }

    protected boolean postParseRequest(Request req, RequestMap request, Response res, ResponseMap response) throws Exception {
        MessageBytes decodedURI = req.decodedURI();
        decodedURI.duplicate(req.requestURI());
        if (decodedURI.getType() == 2) {
            try {
                req.getURLDecoder().convert(decodedURI, false);
            }
            catch (IOException ioe) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                throw ioe;
            }
            if (!CoyoteInvoker.normalize(req.decodedURI())) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                return false;
            }
            this.convertURI(decodedURI, request);
        } else {
            decodedURI.toChars();
        }
        return true;
    }

    protected void convertURI(MessageBytes uri, RequestMap request) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        String enc = this.URIEncoding;
        if (enc != null) {
            B2CConverter conv = request.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    request.setURIConverter(conv);
                } else {
                    conv.recycle();
                }
            }
            catch (IOException e) {
                log.error((Object)"Invalid URI encoding; using HTTP default");
                this.URIEncoding = null;
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc);
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    log.error((Object)"Invalid URI character encoding; trying ascii");
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, bc.getLength());
    }

    protected void convertMB(MessageBytes mb) {
        if (mb.getType() != 2) {
            return;
        }
        ByteChunk bc = mb.getByteChunk();
        CharChunk cc = mb.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        mb.setChars(cbuf, 0, bc.getLength());
    }

    public static boolean normalize(MessageBytes uriMB) {
        int end;
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        if (start - (end = uriBC.getEnd()) == 0) {
            return false;
        }
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                b[pos] = 47;
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                CoyoteInvoker.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start >= 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteInvoker.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteInvoker.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    public void stop() {
        if (this.running) {
            this.running = false;
            if (this.protocolHandlers != null) {
                Iterator it = this.protocolHandlers.iterator();
                while (it.hasNext()) {
                    try {
                        ProtocolHandler protocolHandler = (ProtocolHandler)it.next();
                        protocolHandler.destroy();
                    }
                    catch (Exception e) {
                        log.error((Object)"Stop error", (Throwable)e);
                    }
                }
            }
        }
        super.stop();
        log.debug((Object)"CoyoteInvoker stopped.");
    }

    public static boolean setProperty(final Object o, String name, String value) {
        String setter = "set" + CoyoteInvoker.capitalize(name);
        try {
            int i;
            Method[] methods = null;
            methods = SecurityUtility.skipAccessControl() ? o.getClass().getMethods() : (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return o.getClass().getMethods();
                }
            });
            Method setPropertyMethod = null;
            for (i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (!setter.equals(methods[i].getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                methods[i].invoke(o, value);
                return true;
            }
            for (i = 0; i < methods.length; ++i) {
                boolean ok = true;
                if (setter.equals(methods[i].getName()) && methods[i].getParameterTypes().length == 1) {
                    Class<?> paramType = methods[i].getParameterTypes()[0];
                    Object[] params = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params[0] = new Integer(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                        try {
                            params[0] = new Long(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params[0] = new Boolean(value);
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params[0] = CoyoteInvoker.getAddressByName(value);
                        }
                        catch (UnknownHostException exc) {
                            ok = false;
                        }
                    }
                    if (ok) {
                        methods[i].invoke(o, params);
                        return true;
                    }
                }
                if (!"setProperty".equals(methods[i].getName())) continue;
                setPropertyMethod = methods[i];
            }
            if (setPropertyMethod != null) {
                Object[] params = new Object[]{name, value};
                setPropertyMethod.invoke(o, params);
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public boolean event(Request arg0, Response arg1, SocketStatus arg2) throws Exception {
        return true;
    }

    private static boolean isInvalidContentType(String contentType) {
        return contentType.indexOf(10) + contentType.indexOf(13) > -2;
    }

    private static Object forName(final String className) throws ClassNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            return Class.forName(className);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Class.forName(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getCause();
        }
    }

    private static InetAddress getAddressByName(final String host) throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return InetAddress.getByName(host);
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }
}

