/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.MarshallerDecorator;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.UnMarshallerDecorator;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.marshal.rmi.RMIMarshaller;
import org.jboss.remoting.marshal.rmi.RMIUnMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;
import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory;
import org.jboss.remoting.transport.rmi.RemotingRMIServerSocketFactory;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.serial.io.JBossObjectOutputStream;
import org.jboss.util.propertyeditor.PropertyEditors;

public class RMIServerInvoker
extends ServerInvoker
implements RMIServerInvokerInf,
Cloneable {
    public static String RMI_ONEWAY_MARSHALLING = "rmiOnewayMarshalling";
    private static final Logger log = Logger.getLogger(RMIServerInvoker.class);
    protected boolean isPrimaryServer = true;
    protected Set secondaryServers = new HashSet();
    protected boolean rmiOnewayMarshalling;
    private Remote stub;
    private RemotingRMIClientSocketFactory csf;
    public static final int BACKLOG_DEFAULT = 200;
    public static final int DEFAULT_REGISTRY_PORT = 3455;
    public static final String REGISTRY_PORT_KEY = "registryPort";
    private Marshaller marshaller = null;
    private UnMarshaller unmarshaller = null;

    public RMIServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public void start() throws IOException {
        super.start();
        if (this.isPrimaryServer) {
            List connectHomes = this.getConnectHomes();
            List homes = this.getHomes();
            if (connectHomes.size() != homes.size()) {
                throw new IOException("number of connect homes and bind homes must match in RMI transport");
            }
            Home bindHome = (Home)homes.get(0);
            Home connectHome = (Home)connectHomes.get(0);
            this.initRMI(bindHome, connectHome);
            for (int i = 1; i < homes.size(); ++i) {
                bindHome = (Home)homes.get(i);
                connectHome = (Home)connectHomes.get(i);
                RMIServerInvoker copy = this.copy();
                this.secondaryServers.add(copy);
                copy.initRMI(bindHome, connectHome);
            }
        }
    }

    protected void setup() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.getConfiguration());
        RMIServerInvoker.mapJavaBeanProperties(this, props, false);
        super.setup();
    }

    protected RMIServerInvoker copy() throws IOException {
        Object o = null;
        try {
            o = this.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)"This should not happen", (Throwable)e);
            return this;
        }
        RMIServerInvoker server = (RMIServerInvoker)o;
        server.locator = this.locator;
        server.locator = new InvokerLocator(this.locator.getLocatorURI());
        server.locator.setHomeInUse(this.locator.getHomeInUse());
        server.isPrimaryServer = false;
        server.start();
        return server;
    }

    protected void initRMI(Home bindHome, Home connectHome) throws IOException {
        Registry registry = null;
        try {
            registry = this.getRegistry();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        String bindHost = bindHome.host;
        int bindPort = bindHome.port;
        String clientConnectHost = connectHome.host;
        if (clientConnectHost == null) {
            clientConnectHost = bindHost;
        }
        this.locator.setHomeInUse(bindHome);
        RemotingRMIServerSocketFactory ssf = new RemotingRMIServerSocketFactory(this.getServerSocketFactory(), 200, bindHost, this.getTimeout());
        this.csf = this.getRMIClientSocketFactory(clientConnectHost);
        this.stub = RMIServerInvoker.exportObject(this, bindPort, this.csf, ssf);
        log.debug((Object)("Binding server to \"remoting/RMIServerInvoker/" + bindPort + "\" in registry"));
        RMIServerInvoker.rebind(registry, "remoting/RMIServerInvoker/" + bindPort, this);
        ClassLoader classLoader = RMIServerInvoker.getClassLoader(RMIServerInvoker.class);
        Map map = this.passConfigMapToMarshalFactory ? this.configuration : null;
        this.unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), classLoader, map);
        this.marshaller = MarshalFactory.getMarshaller(this.getLocator(), classLoader, map);
    }

    protected RemotingRMIClientSocketFactory getRMIClientSocketFactory(String clientConnectHost) {
        HashMap remoteConfig = new HashMap(this.configuration);
        remoteConfig.remove("customServerSocketFactory");
        remoteConfig.remove("socketCreationClientListener");
        remoteConfig.remove("socketCreationServerListener");
        return new RemotingRMIClientSocketFactory(this.locator, clientConnectHost, this.getTimeout(), remoteConfig);
    }

    protected SocketFactory getDefaultSocketFactory() {
        return null;
    }

    public RMIServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    private Registry getRegistry() throws Exception {
        String value;
        Registry registry = null;
        int port = 3455;
        Map params = this.getConfiguration();
        if (params != null && (value = (String)params.get(REGISTRY_PORT_KEY)) != null) {
            try {
                port = Integer.parseInt(value);
                log.debug((Object)("Using port " + port + " for rmi registry."));
            }
            catch (NumberFormatException e) {
                throw new Exception("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number.");
            }
        }
        try {
            log.debug((Object)("Creating registry for " + port));
            registry = RMIServerInvoker.createRegistry(port);
        }
        catch (ExportException exportEx) {
            log.debug((Object)("Locating registry for " + port));
            registry = RMIServerInvoker.getRegistry(port);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Got registry: " + registry));
        }
        return registry;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public void destroy() {
        super.destroy();
        try {
            try {
                log.debug((Object)("locator: " + this.locator + ", home: " + this.locator.getHomeInUse()));
                log.debug((Object)(this + " primary: " + this.isPrimaryServer + " unbinding " + "remoting/RMIServerInvoker/" + this.locator.getPort() + " from registry"));
                Registry registry = this.getRegistry();
                RMIServerInvoker.unbind(registry, "remoting/RMIServerInvoker/" + this.locator.getPort());
                log.debug((Object)("unbound remoting/RMIServerInvoker/" + this.locator.getPort() + " from registry"));
            }
            catch (Exception e) {
                if ("Finalizer".equalsIgnoreCase(Thread.currentThread().getName())) {
                    log.debug((Object)("thread: " + Thread.currentThread().getName() + " Error unbinding RMIServerInvoker from RMI registry."), (Throwable)e);
                }
                log.error((Object)("thread: " + Thread.currentThread().getName() + " Error unbinding RMIServerInvoker from RMI registry."), (Throwable)e);
            }
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        if (this.csf != null) {
            this.csf.clear();
        }
        if (this.isPrimaryServer) {
            Iterator it = this.secondaryServers.iterator();
            while (it.hasNext()) {
                RMIServerInvoker server = (RMIServerInvoker)it.next();
                it.remove();
                server.destroy();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    public final Remote getStub() {
        return this.stub;
    }

    public Object transport(Object invocation) throws RemoteException, IOException {
        Object payload = invocation;
        if (this.unmarshaller != null && !(this.unmarshaller instanceof RMIUnMarshaller)) {
            if (this.unmarshaller instanceof UnMarshallerDecorator) {
                payload = ((UnMarshallerDecorator)((Object)this.unmarshaller)).removeDecoration(payload);
            } else {
                ByteArrayInputStream is = null;
                if (this.rmiOnewayMarshalling) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    SerializationManager manager = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
                    ObjectOutputStream oos = manager.createOutput(baos);
                    RMIServerInvoker.writeObject(oos, payload);
                    oos.flush();
                    oos.close();
                    is = new ByteArrayInputStream(baos.toByteArray());
                } else {
                    is = new ByteArrayInputStream((byte[])payload);
                }
                try {
                    if (this.unmarshaller instanceof VersionedUnMarshaller) {
                        payload = ((VersionedUnMarshaller)this.unmarshaller).read(is, null, this.getVersion());
                        is.close();
                    } else {
                        payload = this.unmarshaller.read(is, null);
                        is.close();
                    }
                }
                catch (ClassNotFoundException e) {
                    log.debug((Object)("Could not unmarshall invocation request" + payload), (Throwable)e);
                    throw new IOException(e.getMessage());
                }
            }
        }
        if (payload instanceof InvocationRequest) {
            InvocationRequest ir = (InvocationRequest)payload;
            HashMap<String, InetAddress> metadata = ir.getRequestPayload();
            if (metadata == null) {
                metadata = new HashMap<String, InetAddress>();
                ir.setRequestPayload(metadata);
            }
            try {
                String clientHost = RemoteServer.getClientHost();
                InetAddress clientAddress = RMIServerInvoker.getAddressByName(clientHost);
                metadata.put("clientAddress", clientAddress);
            }
            catch (ServerNotActiveException e) {
                throw new RemoteException(e.getMessage());
            }
        }
        Object response = this.invoke(payload);
        if (this.marshaller != null && !(this.marshaller instanceof RMIMarshaller) && !this.rmiOnewayMarshalling) {
            if (this.marshaller instanceof MarshallerDecorator) {
                response = ((MarshallerDecorator)((Object)this.marshaller)).addDecoration(response);
            } else {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                if (this.marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)this.marshaller).write(response, byteOut, this.getVersion());
                } else {
                    this.marshaller.write(response, byteOut);
                }
                byteOut.close();
                response = byteOut.toByteArray();
            }
        }
        return response;
    }

    public boolean isRmiOnewayMarshalling() {
        return this.rmiOnewayMarshalling;
    }

    public void setRmiOnewayMarshalling(boolean rmiOnewayMarshalling) {
        this.rmiOnewayMarshalling = rmiOnewayMarshalling;
    }

    private static ClassLoader getClassLoader(final Class c) {
        if (SecurityUtility.skipAccessControl()) {
            return c.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return c.getClassLoader();
            }
        });
    }

    private static void mapJavaBeanProperties(final Object o, final Properties props, final boolean isStrict) throws IntrospectionException {
        if (SecurityUtility.skipAccessControl()) {
            PropertyEditors.mapJavaBeanProperties((Object)o, (Properties)props, (boolean)isStrict);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IntrospectionException {
                    PropertyEditors.mapJavaBeanProperties((Object)o, (Properties)props, (boolean)isStrict);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IntrospectionException)e.getCause();
        }
    }

    private static void writeObject(final ObjectOutputStream oos, final Object o) throws IOException {
        if (SecurityUtility.skipAccessControl() || !(oos instanceof JBossObjectOutputStream)) {
            oos.writeObject(o);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    oos.writeObject(o);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw (RuntimeException)cause;
        }
    }

    private static InetAddress getAddressByName(final String host) throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return InetAddress.getByName(host);
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    private static Registry createRegistry(final int port) throws RemoteException {
        if (SecurityUtility.skipAccessControl()) {
            return LocateRegistry.createRegistry(port);
        }
        try {
            return (Registry)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return LocateRegistry.createRegistry(port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RemoteException)e.getCause();
        }
    }

    private static Remote exportObject(final Remote object, final int port, final RMIClientSocketFactory csf, final RMIServerSocketFactory ssf) throws RemoteException {
        if (SecurityUtility.skipAccessControl()) {
            return UnicastRemoteObject.exportObject(object, port, csf, ssf);
        }
        try {
            return (Remote)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return UnicastRemoteObject.exportObject(object, port, csf, ssf);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RemoteException)e.getCause();
        }
    }

    private static Registry getRegistry(final int port) throws RemoteException {
        if (SecurityUtility.skipAccessControl()) {
            return LocateRegistry.getRegistry(port);
        }
        try {
            return (Registry)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return LocateRegistry.getRegistry(port);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RemoteException)e.getCause();
        }
    }

    private static void rebind(final Registry registry, final String name, final Remote object) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            registry.rebind(name, object);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    registry.rebind(name, object);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static void unbind(final Registry registry, final String name) throws AccessException, RemoteException, NotBoundException {
        if (SecurityUtility.skipAccessControl()) {
            registry.unbind(name);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws AccessException, RemoteException, NotBoundException {
                    registry.unbind(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AccessException) {
                throw (AccessException)cause;
            }
            if (cause instanceof RemoteException) {
                throw (RemoteException)cause;
            }
            throw (NotBoundException)cause;
        }
    }
}

