/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.util.HashMap;
import java.util.Map;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerImpl;
import org.jboss.xb.binding.parser.JBossXBParser;

public abstract class UnmarshallerFactory {
    protected Map<String, Object> features;
    protected Boolean validation = Boolean.TRUE;
    protected Boolean namespaces = Boolean.TRUE;

    public static UnmarshallerFactory newInstance() {
        return new UnmarshallerFactoryImpl();
    }

    public abstract Unmarshaller newUnmarshaller();

    public void setFeature(String name, Object value) {
        Boolean bValue;
        if (value == null) {
            bValue = null;
        } else if (value instanceof String) {
            bValue = Boolean.valueOf((String)value);
        } else if (value instanceof Boolean) {
            bValue = (Boolean)value;
        } else {
            throw new JBossXBRuntimeException("Allowed feature values are null, 'true, 'false', Boolean.TRUE, Boolean.FALSE. Passed in value: " + value);
        }
        if ("http://xml.org/sax/features/validation".equals(name)) {
            this.validation = bValue;
        } else if ("http://xml.org/sax/features/namespaces".equals(name)) {
            this.namespaces = bValue;
        } else {
            if (this.features == null) {
                this.features = new HashMap<String, Object>();
            }
            this.features.put(name, value);
        }
    }

    static class UnmarshallerFactoryImpl
    extends UnmarshallerFactory {
        UnmarshallerFactoryImpl() {
        }

        public Unmarshaller newUnmarshaller() {
            UnmarshallerImpl unmarshaller;
            try {
                unmarshaller = new UnmarshallerImpl();
            }
            catch (JBossXBException e) {
                throw new JBossXBRuntimeException(e.getMessage(), e);
            }
            JBossXBParser parser = unmarshaller.getParser();
            if (this.validation != null) {
                parser.setFeature("http://xml.org/sax/features/validation", this.validation);
            }
            if (this.namespaces != null) {
                parser.setFeature("http://xml.org/sax/features/namespaces", this.namespaces);
            }
            if (this.features != null) {
                for (Map.Entry entry : this.features.entrySet()) {
                    if (entry.getValue() == null) continue;
                    Boolean value = (Boolean)entry.getValue();
                    parser.setFeature((String)entry.getKey(), value);
                }
            }
            try {
                parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
            catch (JBossXBRuntimeException jBossXBRuntimeException) {
                // empty catch block
            }
            return unmarshaller;
        }
    }
}

