/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.ejb3.ClientKernelAbstraction;
import org.jboss.ejb3.JmxKernelAbstraction;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;

public class JmxClientKernelAbstraction
implements ClientKernelAbstraction {
    private static final Logger log = Logger.getLogger(JmxKernelAbstraction.class);
    private MBeanServerConnection server;

    public JmxClientKernelAbstraction(MBeanServerConnection server) {
        this.server = server;
    }

    private Exception decode(Exception e) {
        Throwable t = JMXExceptionDecoder.decode((Throwable)e);
        if (t instanceof Exception) {
            return (Exception)t;
        }
        throw (Error)t;
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws Exception {
        try {
            return this.server.invoke(name, operationName, params, signature);
        }
        catch (Exception e) {
            throw this.decode(e);
        }
    }

    public Object getAttribute(ObjectName name, String attribute) throws Exception {
        try {
            return this.server.getAttribute(name, attribute);
        }
        catch (Exception e) {
            throw this.decode(e);
        }
    }

    public Set getMBeans(ObjectName query) throws Exception {
        Set<ObjectInstance> mbeans = this.server.queryMBeans(query, null);
        return mbeans;
    }
}

