/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceContexts;
import org.jboss.ejb3.annotation.IgnoreDependency;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.JndiFieldInjector;
import org.jboss.injection.JndiMethodInjector;
import org.jboss.injection.PcEncInjector;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceContextHandler<X extends RemoteEnvironment>
implements InjectionHandler<X> {
    private static final Logger log = Logger.getLogger(PersistenceContextHandler.class);

    @Override
    public void loadXml(X xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (!(xml instanceof Environment)) {
            return;
        }
        Environment env = (Environment)xml;
        if (env.getPersistenceContextRefs() == null) {
            return;
        }
        for (PersistenceContextReferenceMetaData ref : env.getPersistenceContextRefs()) {
            String encName = "env/" + ref.getPersistenceContextRefName();
            Class<?> injectionType = InjectionUtil.injectionTarget(encName, (ResourceInjectionMetaData)ref, container, container.getEncInjections());
            if (container.getEncInjectors().containsKey(encName)) continue;
            String error = "unable to load <persistence-context-ref> for unitName: " + ref.getPersistenceUnitName() + " <ref-name>: " + ref.getPersistenceContextRefName();
            PersistenceContextType type = ref.getPersistenceContextType();
            String unitName = ref.getPersistenceUnitName();
            container.getEncInjectors().put(encName, new PcEncInjector(encName, unitName, type, injectionType, error));
            try {
                PersistenceUnitHandler.addPUDependency(ref.getPersistenceUnitName(), container);
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Illegal <persistence-context-ref> of " + ref.getPersistenceContextRefName() + " :" + e.getMessage());
            }
        }
    }

    @Override
    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        PersistenceContext pc;
        PersistenceContexts resources = container.getAnnotation(PersistenceContexts.class, clazz);
        if (resources != null) {
            for (PersistenceContext ref : resources.value()) {
                PersistenceContextHandler.loadPersistenceContextClassAnnotation(ref, container, clazz);
            }
        }
        if ((pc = container.getAnnotation(PersistenceContext.class, clazz)) != null) {
            PersistenceContextHandler.loadPersistenceContextClassAnnotation(pc, container, clazz);
        }
    }

    private static void loadPersistenceContextClassAnnotation(PersistenceContext ref, InjectionContainer container, Class<?> clazz) {
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires name() for class level @PersistenceContext");
        }
        encName = "env/" + ref.name();
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        String error = "Unable to load class-level @PersistenceContext(" + ref.unitName() + ") on " + container.getIdentifier();
        container.getEncInjectors().put(encName, new PcEncInjector(encName, ref.unitName(), ref.type(), null, error));
        try {
            PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
        }
        catch (NameNotFoundException e) {
            throw new RuntimeException("Illegal @PersistenceUnit on " + clazz.getName() + " of unitname " + ref.unitName() + " :" + e.getMessage());
        }
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        PersistenceContext ref = method.getAnnotation(PersistenceContext.class);
        if (ref == null) {
            return;
        }
        if (!method.getName().startsWith("set")) {
            throw new RuntimeException("@PersistenceUnit can only be used with a set method: " + method);
        }
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(method) : "env/" + ref.name();
        if (!container.getEncInjectors().containsKey(encName)) {
            try {
                if (!method.isAnnotationPresent(IgnoreDependency.class)) {
                    PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                }
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Illegal @PersistenceUnit on " + method + " :" + e.getMessage());
            }
            String error = "@PersistenceContext(name='" + encName + "',unitName='" + ref.unitName() + "') on EJB: " + container.getIdentifier() + " failed to inject on method " + method.toString();
            container.getEncInjectors().put(encName, new PcEncInjector(encName, ref.unitName(), ref.type(), method.getParameterTypes()[0], error));
        }
        injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        PersistenceContext ref = field.getAnnotation(PersistenceContext.class);
        if (ref == null) {
            return;
        }
        String encName = ref.name();
        encName = encName == null || encName.equals("") ? InjectionUtil.getEncName(field) : "env/" + ref.name();
        if (!container.getEncInjectors().containsKey(encName)) {
            try {
                if (!field.isAnnotationPresent(IgnoreDependency.class)) {
                    PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
                }
            }
            catch (NameNotFoundException e) {
                throw new RuntimeException("Illegal @PersistenceUnit on " + field + " :" + e.getMessage());
            }
            String error = "@PersistenceContext(name='" + encName + "',unitName='" + ref.unitName() + "') on EJB: " + container.getIdentifier() + " failed to inject on field " + field.toString();
            container.getEncInjectors().put(encName, new PcEncInjector(encName, ref.unitName(), ref.type(), field.getType(), error));
        }
        injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
    }
}

