/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.validation.chain.ejb.jboss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.validation.ValidationException;
import org.jboss.metadata.validation.chain.ValidatorChain;
import org.jboss.metadata.validation.chain.ValidatorChainException;
import org.jboss.metadata.validation.validator.Validator;
import org.jboss.metadata.validation.validator.ejb.jboss.CompleteEjb2xViewValidator;
import org.jboss.metadata.validation.validator.ejb.jboss.LocalBindingWithNoLocalInterfaceValidator;
import org.jboss.metadata.validation.validator.ejb.jboss.RemoteBindingsWithNoRemoteBusinessInterfaceValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossMetaDataValidatorChain<T extends JBossMetaData>
implements ValidatorChain<T> {
    private static final Logger log = Logger.getLogger(JBossMetaDataValidatorChain.class);
    private List<Validator> validators = new ArrayList<Validator>();

    public JBossMetaDataValidatorChain() {
        this(JBossMetaDataValidatorChain.getDefaultValidators());
    }

    public JBossMetaDataValidatorChain(List<Validator> validators) {
        assert (validators != null) : "Specified validators for chain was null";
        for (Validator validator : validators) {
            log.trace((Object)("Added Validator to " + this + ": " + validator.getClass().getSimpleName()));
            this.addValidator(validator);
        }
    }

    @Override
    public void validate(T metadata) throws ValidationException {
        ArrayList<ValidationException> validationExceptions = new ArrayList<ValidationException>();
        List<Validator> validators = this.getValidators();
        for (Validator validator : validators) {
            try {
                validator.validate((JBossMetaData)metadata);
            }
            catch (ValidationException ve) {
                validationExceptions.add(ve);
            }
        }
        if (validationExceptions.size() > 0) {
            throw new ValidatorChainException(validationExceptions);
        }
        log.debug((Object)("Passed Validation on all configured validators for " + metadata));
    }

    @Override
    public List<Validator> getValidators() {
        List<Validator> validators = Collections.unmodifiableList(this._getValidators());
        return validators;
    }

    @Override
    public void addValidator(Validator validator) {
        assert (validator != null) : "Specified validator was null";
        this._getValidators().add(validator);
    }

    protected static List<Validator> getDefaultValidators() {
        ArrayList<Validator> defaultValidators = new ArrayList<Validator>();
        defaultValidators.add(LocalBindingWithNoLocalInterfaceValidator.INSTANCE);
        defaultValidators.add(RemoteBindingsWithNoRemoteBusinessInterfaceValidator.INSTANCE);
        defaultValidators.add(CompleteEjb2xViewValidator.INSTANCE);
        return defaultValidators;
    }

    protected List<Validator> _getValidators() {
        return this.validators;
    }

    protected void setValidators(List<Validator> validators) {
        this.validators = validators;
    }
}

