/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore;

import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.IdentifierBag;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.TModelBag;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.BusinessInfo;
import org.apache.juddi.datatype.response.PublisherInfo;
import org.apache.juddi.datatype.response.ServiceInfo;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.error.RegistryException;

public interface DataStore {
    public void release();

    public void beginTrans() throws RegistryException;

    public void commit() throws RegistryException;

    public void rollback() throws RegistryException;

    public Publisher getPublisher(String var1) throws RegistryException;

    public boolean isAdministrator(String var1) throws RegistryException;

    public String generateToken(Publisher var1) throws RegistryException;

    public void storeAuthToken(String var1, Publisher var2) throws RegistryException;

    public void retireAuthToken(String var1) throws RegistryException;

    public Publisher getAuthTokenPublisher(String var1) throws RegistryException;

    public boolean isAuthTokenExpired(String var1) throws RegistryException;

    public void touchAuthToken(String var1) throws RegistryException;

    public void saveBusiness(BusinessEntity var1, String var2) throws RegistryException;

    public BusinessEntity fetchBusiness(String var1) throws RegistryException;

    public void deleteBusiness(String var1) throws RegistryException;

    public boolean isBusinessPublisher(String var1, String var2) throws RegistryException;

    public boolean isValidBusinessKey(String var1) throws RegistryException;

    public void saveService(BusinessService var1) throws RegistryException;

    public BusinessService fetchService(String var1) throws RegistryException;

    public void deleteService(String var1) throws RegistryException;

    public boolean isValidServiceKey(String var1) throws RegistryException;

    public boolean isServicePublisher(String var1, String var2) throws RegistryException;

    public void saveBinding(BindingTemplate var1) throws RegistryException;

    public BindingTemplate fetchBinding(String var1) throws RegistryException;

    public void deleteBinding(String var1) throws RegistryException;

    public boolean isValidBindingKey(String var1) throws RegistryException;

    public boolean isBindingPublisher(String var1, String var2) throws RegistryException;

    public void saveTModel(TModel var1, String var2) throws RegistryException;

    public TModel fetchTModel(String var1) throws RegistryException;

    public void deleteTModel(String var1) throws RegistryException;

    public void markTModelAsDeleted(String var1) throws RegistryException;

    public boolean isValidTModelKey(String var1) throws RegistryException;

    public boolean isTModelPublisher(String var1, String var2) throws RegistryException;

    public BusinessInfo fetchBusinessInfo(String var1) throws RegistryException;

    public ServiceInfo fetchServiceInfo(String var1) throws RegistryException;

    public TModelInfo fetchTModelInfo(String var1) throws RegistryException;

    public Vector findBusiness(Vector var1, DiscoveryURLs var2, IdentifierBag var3, CategoryBag var4, TModelBag var5, FindQualifiers var6) throws RegistryException;

    public Vector findService(String var1, Vector var2, CategoryBag var3, TModelBag var4, FindQualifiers var5) throws RegistryException;

    public Vector findBinding(String var1, CategoryBag var2, TModelBag var3, FindQualifiers var4) throws RegistryException;

    public Vector findTModel(String var1, CategoryBag var2, IdentifierBag var3, FindQualifiers var4) throws RegistryException;

    public Vector findRelatedBusinesses(String var1, KeyedReference var2, FindQualifiers var3) throws RegistryException;

    public Vector findRegisteredBusinesses(String var1) throws RegistryException;

    public Vector findRegisteredTModels(String var1) throws RegistryException;

    public void saveAssertions(String var1, Vector var2) throws RegistryException;

    public void deleteAssertions(String var1, Vector var2) throws RegistryException;

    public Vector getAssertions(String var1) throws RegistryException;

    public Vector setAssertions(String var1, Vector var2) throws RegistryException;

    public Vector getAssertionStatusItems(String var1, String var2) throws RegistryException;

    public void savePublisher(Publisher var1) throws RegistryException;

    public void deletePublisher(String var1) throws RegistryException;

    public PublisherInfo fetchPublisherInfo(String var1) throws RegistryException;

    public Vector findPublisher(String var1, FindQualifiers var2) throws RegistryException;
}

