/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.jboss.metatype.api.types.Name;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.SimpleValue;

public class SimpleValueSupport
extends AbstractMetaValue
implements SimpleValue {
    private static final long serialVersionUID = 8473043036261557127L;
    private SimpleMetaType metaType;
    private Serializable value;

    public static SimpleValue wrap(Serializable object) {
        if (object == null) {
            return null;
        }
        String className = object.getClass().getName();
        return SimpleValueSupport.wrap(object, className);
    }

    private static SimpleValue wrap(Serializable object, String className) {
        SimpleMetaType metaType = SimpleMetaType.resolve(className);
        return new SimpleValueSupport(metaType, object);
    }

    public static SimpleValue wrap(boolean value) {
        return SimpleValueSupport.wrap(Boolean.valueOf(value), Boolean.TYPE.getName());
    }

    public static SimpleValue wrap(byte value) {
        return SimpleValueSupport.wrap(Byte.valueOf(value), Byte.TYPE.getName());
    }

    public static SimpleValue wrap(char value) {
        return SimpleValueSupport.wrap(Character.valueOf(value), Character.TYPE.getName());
    }

    public static SimpleValue wrap(short value) {
        return SimpleValueSupport.wrap(Short.valueOf(value), Short.TYPE.getName());
    }

    public static SimpleValue wrap(int value) {
        return SimpleValueSupport.wrap(Integer.valueOf(value), Integer.TYPE.getName());
    }

    public static SimpleValue wrap(long value) {
        return SimpleValueSupport.wrap(Long.valueOf(value), Long.TYPE.getName());
    }

    public static SimpleValue wrap(float value) {
        return SimpleValueSupport.wrap(Float.valueOf(value), Float.TYPE.getName());
    }

    public static SimpleValue wrap(double value) {
        return SimpleValueSupport.wrap(Double.valueOf(value), Double.TYPE.getName());
    }

    public SimpleValueSupport(SimpleMetaType metaType, Serializable value) {
        if (metaType == null) {
            throw new IllegalArgumentException("Null simple meta type");
        }
        this.metaType = metaType;
        this.setValue(value);
    }

    public SimpleMetaType getMetaType() {
        return this.metaType;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SimpleValue)) {
            return false;
        }
        SimpleValue other = (SimpleValue)obj;
        if (!this.metaType.equals(other.getMetaType()) && !this.metaType.equalsIgnorePrimitive(other.getMetaType())) {
            return false;
        }
        Serializable otherValue = other.getValue();
        if (this.value == null && otherValue == null) {
            return true;
        }
        if (this.value == null && otherValue != null) {
            return false;
        }
        return this.value.equals(otherValue);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.metaType + ":" + this.value;
    }

    public int compareTo(SimpleValue sv) {
        int compare = -1;
        if (this.getMetaType() == SimpleMetaType.BIGINTEGER && sv.getMetaType() == SimpleMetaType.BIGINTEGER) {
            BigInteger v1 = (BigInteger)BigInteger.class.cast(this.value);
            BigInteger v2 = (BigInteger)BigInteger.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.BIGDECIMAL && sv.getMetaType() == SimpleMetaType.BIGDECIMAL) {
            BigDecimal v1 = (BigDecimal)BigDecimal.class.cast(this.value);
            BigDecimal v2 = (BigDecimal)BigDecimal.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.BOOLEAN && sv.getMetaType() == SimpleMetaType.BOOLEAN) {
            Boolean v1 = (Boolean)Boolean.class.cast(this.value);
            Boolean v2 = (Boolean)Boolean.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.BOOLEAN_PRIMITIVE && sv.getMetaType() == SimpleMetaType.BOOLEAN_PRIMITIVE) {
            Boolean v1 = (Boolean)Boolean.class.cast(this.value);
            Boolean v2 = (Boolean)Boolean.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.BYTE && sv.getMetaType() == SimpleMetaType.BYTE) {
            Byte v1 = (Byte)Byte.class.cast(this.value);
            Byte v2 = (Byte)Byte.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.CHARACTER && sv.getMetaType() == SimpleMetaType.CHARACTER) {
            Character v1 = (Character)Character.class.cast(this.value);
            Character v2 = (Character)Character.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.CHARACTER_PRIMITIVE && sv.getMetaType() == SimpleMetaType.CHARACTER_PRIMITIVE) {
            Character v1 = (Character)Character.class.cast(this.value);
            Character v2 = (Character)Character.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.DATE && sv.getMetaType() == SimpleMetaType.DATE) {
            Date v1 = (Date)Date.class.cast(this.value);
            Date v2 = (Date)Date.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.DOUBLE && sv.getMetaType() == SimpleMetaType.DOUBLE) {
            Double v1 = (Double)Double.class.cast(this.value);
            Double v2 = (Double)Double.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.FLOAT && sv.getMetaType() == SimpleMetaType.FLOAT) {
            Float v1 = (Float)Float.class.cast(this.value);
            Float v2 = (Float)Float.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.INTEGER && sv.getMetaType() == SimpleMetaType.INTEGER) {
            Integer v1 = (Integer)Integer.class.cast(this.value);
            Integer v2 = (Integer)Integer.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.LONG && sv.getMetaType() == SimpleMetaType.LONG) {
            Long v1 = (Long)Long.class.cast(this.value);
            Long v2 = (Long)Long.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.SHORT && sv.getMetaType() == SimpleMetaType.SHORT) {
            Short v1 = (Short)Short.class.cast(this.value);
            Short v2 = (Short)Short.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.STRING && sv.getMetaType() == SimpleMetaType.STRING) {
            String v1 = (String)String.class.cast(this.value);
            String v2 = (String)String.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.NAMEDOBJECT && sv.getMetaType() == SimpleMetaType.NAMEDOBJECT) {
            Name v1 = (Name)Name.class.cast(this.value);
            Name v2 = (Name)Name.class.cast(sv.getValue());
            compare = v1.compareTo(v2);
        } else if (this.getMetaType() == SimpleMetaType.VOID && sv.getMetaType() == SimpleMetaType.VOID) {
            compare = 0;
        } else if (this.value instanceof Number && sv.getValue() instanceof Number) {
            Number n0 = (Number)this.value;
            Number n1 = (Number)sv.getValue();
            if (n0 instanceof BigDecimal) {
                BigDecimal db0 = (BigDecimal)n0;
                BigDecimal db1 = new BigDecimal(n1.doubleValue());
                compare = db0.compareTo(db1);
            } else if (n1 instanceof BigDecimal) {
                BigDecimal db1 = (BigDecimal)n1;
                BigDecimal db0 = new BigDecimal(n0.doubleValue());
                compare = db0.compareTo(db1);
            } else if (n0 instanceof Float || n0 instanceof Double || n1 instanceof Float || n1 instanceof Double) {
                double d0 = n0.doubleValue();
                double d1 = n1.doubleValue();
                compare = Double.compare(d0, d1);
            } else {
                long l1;
                long l0 = n0.longValue();
                compare = l0 < (l1 = n1.longValue()) ? -1 : (l0 > l1 ? 1 : 0);
            }
        }
        return compare;
    }
}

