/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.entity;

import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.modules.ejb.entity.PkTagsHandler;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;

public class EntityPkSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String DEFAULT_ENTITY_PK_CLASS_PATTERN = "{0}PK";
    protected static final String DEFAULT_TEMPLATE_FILE = "resources/entitypk.xdt";
    protected String entityPkClassPattern;

    public EntityPkSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getEntityPkClassPattern() + ".java");
        this.addOfType("javax.ejb.EntityBean");
    }

    public String getEntityPkClassPattern() {
        if (this.entityPkClassPattern != null) {
            return this.entityPkClassPattern;
        }
        return DEFAULT_ENTITY_PK_CLASS_PATTERN;
    }

    public void setPattern(String new_pattern) {
        this.entityPkClassPattern = new_pattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getEntityPkClassPattern() == null || this.getEntityPkClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"PARAMETER_MISSING_OR_EMPTY", (String[])new String[]{"pattern"}));
        }
        if (this.getEntityPkClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"PATTERN_HAS_NO_PLACEHOLDER"));
        }
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor((String)PkTagsHandler.getPkClassFor(this.getCurrentClass())) + ".java";
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        Log log = LogUtil.getLog(EntityPkSubTask.class, (String)"matchesGenerationRules");
        if (log.isDebugEnabled()) {
            log.debug((Object)("clazz=" + clazz));
        }
        if ("false".equalsIgnoreCase(clazz.getDoc().getTagAttributeValue("ejb:pk", "generate", false))) {
            log.debug((Object)("Skip primary key for " + clazz.getQualifiedName() + " because of false generate flag"));
            return false;
        }
        if (PkTagsHandler.classHasPrimkeyField(clazz)) {
            log.debug((Object)("Skip primary key for " + clazz.getQualifiedName() + " because it has a PK Field."));
            return false;
        }
        return true;
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletModulesEjbMessages.class, (String)"GENERATING_PK_FOR", (String[])new String[]{this.getCurrentClass().getQualifiedName()}));
    }
}

