/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.modify;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.vfs.plugins.structure.modify.AbstractModificationTypeMatcher;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileModificationTypeMatcher
extends AbstractModificationTypeMatcher {
    private String[] paths;
    private boolean metadataOnly;

    public FileModificationTypeMatcher(String ... paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Null or empty paths");
        }
        this.paths = paths;
    }

    @Override
    protected boolean isModificationDetermined(VirtualFile root, ContextInfo contextInfo) {
        for (String path : this.paths) {
            for (VirtualFile file : this.getStartingFiles(root, contextInfo)) {
                try {
                    if (file.getChild(path) == null) continue;
                    return true;
                }
                catch (Exception e) {
                    this.log.debug((Object)("Cannot determine modification type, cause: " + e));
                }
            }
        }
        return false;
    }

    protected List<VirtualFile> getStartingFiles(VirtualFile file, ContextInfo contextInfo) {
        if (this.metadataOnly) {
            List metadataPaths = contextInfo.getMetaDataPath();
            if (metadataPaths == null || metadataPaths.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(metadataPaths.size());
            for (String metadataPath : metadataPaths) {
                try {
                    VirtualFile child = file.getChild(metadataPath);
                    if (child == null) continue;
                    result.add(child);
                }
                catch (Exception ignored) {}
            }
            return result;
        }
        return Collections.singletonList(file);
    }

    public void setMetadataOnly(boolean metadataOnly) {
        this.metadataOnly = metadataOnly;
    }
}

