/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.modify;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.StructureProcessor;
import org.jboss.deployers.vfs.plugins.structure.modify.ModificationTypeMatcher;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationTypeStructureProcessor
implements StructureProcessor {
    private List<ModificationTypeMatcher> matchers;

    public void prepareStructureMetaData(Deployment deployment, StructureMetaData structureMetaData) {
        if (!(deployment instanceof VFSDeployment)) {
            return;
        }
        VFSDeployment vfsDeployment = (VFSDeployment)VFSDeployment.class.cast(deployment);
        VirtualFile root = vfsDeployment.getRoot();
        this.checkForModification(root, structureMetaData);
    }

    public void prepareContextInfo(DeploymentContext parentDeploymentContext, ContextInfo contextInfo) {
        if (!(parentDeploymentContext instanceof VFSDeploymentContext) || contextInfo == null) {
            return;
        }
        VFSDeploymentContext vfsParentDeploymentContext = (VFSDeploymentContext)VFSDeploymentContext.class.cast(parentDeploymentContext);
        VirtualFile root = vfsParentDeploymentContext.getFile(contextInfo.getPath());
        this.checkForModification(root, contextInfo);
    }

    public void applyStructureMetaData(DeploymentContext deploymentContext, StructureMetaData structureMetaData) {
    }

    public void applyContextInfo(DeploymentContext deploymentContext, ContextInfo contextInfo) {
    }

    protected void checkForModification(VirtualFile root, StructureMetaData structureMetaData) {
        block2: {
            ContextInfo contex = structureMetaData.getContext("");
            if (contex == null || contex.getModificationType() != null) {
                return;
            }
            if (this.matchers == null || this.matchers.isEmpty()) break block2;
            for (ModificationTypeMatcher matcher : this.matchers) {
                if (matcher.determineModification(root, structureMetaData)) break;
            }
        }
    }

    protected void checkForModification(VirtualFile root, ContextInfo contextInfo) {
        block2: {
            if (root == null || contextInfo == null || contextInfo.getModificationType() != null) {
                return;
            }
            if (this.matchers == null || this.matchers.isEmpty()) break block2;
            for (ModificationTypeMatcher matcher : this.matchers) {
                if (matcher.determineModification(root, contextInfo)) break;
            }
        }
    }

    public void setMatchers(List<ModificationTypeMatcher> matchers) {
        this.matchers = matchers;
    }

    public void addMatcher(ModificationTypeMatcher matcher) {
        if (this.matchers == null) {
            this.matchers = new ArrayList<ModificationTypeMatcher>();
        }
        this.matchers.add(matcher);
    }

    public void removeMatcher(ModificationTypeMatcher matcher) {
        if (this.matchers != null) {
            this.matchers.remove(matcher);
        }
    }
}

