/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.MethodJoinPointGenerator;
import org.jboss.aop.util.JavassistMethodHashing;

public class GeneratedAdvisorMethodExecutionTransformer
extends MethodExecutionTransformer {
    public GeneratedAdvisorMethodExecutionTransformer(GeneratedAdvisorInstrumentor instrumentor) {
        super(instrumentor);
    }

    protected String addMethodInfoFieldToGenAdvisor(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException, CannotCompileException {
        GeneratedAdvisorInstrumentor instrumentor = (GeneratedAdvisorInstrumentor)trans.getInstrumentor();
        CtClass genadvisor = instrumentor.getGenadvisor();
        String miname = this.addMethodInfoField(1, genadvisor, trans);
        this.addJoinpoint(miname, trans);
        instrumentor.initaliseMethodInfo(miname, trans.getHash(), JavassistMethodHashing.methodHash(trans.getMethod()));
        return miname;
    }

    protected boolean addInfoAsWeakReference() {
        return false;
    }

    protected boolean markInfoAsSynthetic() {
        return false;
    }

    public static String getJoinPointFieldName(MethodExecutionTransformer.MethodTransformation trans) {
        return MethodJoinPointGenerator.getGeneratedJoinPointFieldName(trans.getOriginalName(), trans.getHash());
    }

    private void addJoinpoint(String miname, MethodExecutionTransformer.MethodTransformation trans) throws CannotCompileException, NotFoundException {
        CtClass joinpoint = this.createJoinpointClass(miname, trans);
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)trans.getInstrumentor()).getGenadvisor();
        CtField field = new CtField(joinpoint, GeneratedAdvisorMethodExecutionTransformer.getJoinPointFieldName(trans), genadvisor);
        field.setModifiers(1);
        genadvisor.addField(field);
    }

    private CtClass createJoinpointClass(String miname, MethodExecutionTransformer.MethodTransformation trans) throws CannotCompileException, NotFoundException {
        return MethodJoinPointGenerator.createJoinpointBaseClass((GeneratedAdvisorInstrumentor)trans.getInstrumentor(), trans.getClazz(), trans.getMethod(), trans.getWMethod(), miname, trans.getOriginalName(), trans.getWrappedName(), trans.getHash());
    }

    public CtMethod addMixinWrappersAndInfo(GeneratedAdvisorInstrumentor instrumentor, CtClass clazz, CtClass mixinClass, String initializer, CtClass genadvisor, CtMethod mixinMethod) throws CannotCompileException, NotFoundException {
        String originalName = mixinMethod.getName();
        String originalBody = "{   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(mixinMethod) + " " + Instrumentor.mixinFieldName(mixinClass) + "." + mixinMethod.getName() + "($$);" + "}";
        CtMethod original = CtNewMethod.make((int)1, (CtClass)mixinMethod.getReturnType(), (String)mixinMethod.getName(), (CtClass[])mixinMethod.getParameterTypes(), (CtClass[])mixinMethod.getExceptionTypes(), (String)originalBody, (CtClass)clazz);
        clazz.addMethod(original);
        long hash = JavassistMethodHashing.methodHash(original);
        this.moveAnnotationsAndCopySignature(mixinMethod, original);
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), originalName);
        CtMethod wmethod = CtNewMethod.copy((CtMethod)original, (CtClass)clazz, null);
        wmethod.setName(wrappedName);
        clazz.addMethod(wmethod);
        this.moveAnnotationsAndCopySignature(original, wmethod);
        original.setName(wrappedName);
        Instrumentor.addSyntheticAttribute(original);
        wmethod.setName(originalName);
        MethodExecutionTransformer.MethodTransformation trans = new MethodExecutionTransformer.MethodTransformation(instrumentor, clazz, original, originalName, wmethod, wrappedName, hash);
        String methodInfoField = this.addMethodInfoFieldToGenAdvisor(trans);
        this.addMethodToGeneratedAdvisor(trans, methodInfoField);
        String wrapperBody = "{   if (" + Instrumentor.mixinFieldName(mixinClass) + " == null)" + "   {" + "      " + Instrumentor.mixinFieldName(mixinClass) + " = " + initializer + ";" + "   }" + "   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getMethod()) + " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(trans.getClazz()) + ")" + "getCurrentAdvisor$aop()" + ")." + this.getAdvisorMethodName(trans) + "(this,$$);" + "}";
        wmethod.setBody(wrapperBody);
        return wmethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CtMethod addMixinWrappersAndInfo(GeneratedAdvisorInstrumentor instrumentor, CtClass clazz, CtClass genadvisor, CtMethod mixinMethod, CtMethod delegate) throws CannotCompileException, NotFoundException {
        String originalName = mixinMethod.getName();
        String originalBody = "{ ";
        CtClass returnType = mixinMethod.getReturnType();
        if (!returnType.equals(CtClass.voidType)) {
            if (returnType.isPrimitive()) {
                if (returnType.equals(CtClass.booleanType)) {
                    originalBody = originalBody + "return false;";
                } else if (returnType.equals(CtClass.byteType)) {
                    originalBody = originalBody + "return (byte) 0;";
                } else if (returnType.equals(CtClass.charType)) {
                    originalBody = originalBody + "return (char) 0;";
                } else if (returnType.equals(CtClass.doubleType)) {
                    originalBody = originalBody + "return (double) 0.0;";
                } else if (returnType.equals(CtClass.floatType)) {
                    originalBody = originalBody + "return (float) 0.0;";
                } else if (returnType.equals(CtClass.intType)) {
                    originalBody = originalBody + "return 0;";
                } else if (returnType.equals(CtClass.longType)) {
                    originalBody = originalBody + "return 0l;";
                } else {
                    if (!returnType.equals(CtClass.shortType)) throw new RuntimeException("Unexpected primitive type: " + returnType.getName());
                    originalBody = originalBody + "return (short) 0;";
                }
            } else {
                originalBody = originalBody + "return null;";
            }
        }
        originalBody = originalBody + "}";
        CtMethod original = CtNewMethod.make((int)1, (CtClass)mixinMethod.getReturnType(), (String)mixinMethod.getName(), (CtClass[])mixinMethod.getParameterTypes(), (CtClass[])mixinMethod.getExceptionTypes(), (String)originalBody, (CtClass)clazz);
        clazz.addMethod(original);
        long hash = JavassistMethodHashing.methodHash(original);
        this.moveAnnotationsAndCopySignature(mixinMethod, original);
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), originalName);
        CtMethod wmethod = CtNewMethod.copy((CtMethod)original, (CtClass)clazz, null);
        wmethod.setName(wrappedName);
        clazz.addMethod(wmethod);
        this.moveAnnotationsAndCopySignature(original, wmethod);
        original.setName(wrappedName);
        Instrumentor.addSyntheticAttribute(original);
        wmethod.setName(originalName);
        MethodExecutionTransformer.MethodTransformation trans = new MethodExecutionTransformer.MethodTransformation(instrumentor, clazz, original, originalName, wmethod, wrappedName, hash);
        String methodInfoField = this.addMethodInfoFieldToGenAdvisor(trans);
        String body = "{ return ((org.jboss.aop.ClassAdvisor)this._getAdvisor()).invokeMethod($1, ";
        body = body + trans.getHash() + "L";
        for (int i = 0; i < mixinMethod.getParameterTypes().length; ++i) {
            body = body + "$" + (i + 2);
        }
        body = body + ");}";
        this.addMethodToGeneratedAdvisor(trans, methodInfoField, body);
        String wrapperBody = "{   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getMethod()) + " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(trans.getClazz()) + ")" + "getCurrentAdvisor$aop()" + ")." + this.getAdvisorMethodName(trans) + "(this,$$);" + "}";
        wmethod.setBody(wrapperBody);
        return wmethod;
    }

    public void addMethodIntroductionInfo(GeneratedAdvisorInstrumentor instrumentor, CtClass clazz, CtMethod introducedMethod, long hash) throws CannotCompileException, NotFoundException {
        MethodExecutionTransformer.MethodTransformation trans = new MethodExecutionTransformer.MethodTransformation(instrumentor, clazz, introducedMethod, introducedMethod.getName(), introducedMethod, introducedMethod.getName(), hash);
        String methodInfoField = this.addMethodInfoFieldToGenAdvisor(trans);
        this.addMethodToGeneratedAdvisor(trans, methodInfoField);
    }

    protected void transformMethod(MethodExecutionTransformer.MethodTransformation trans, boolean wrap) throws CannotCompileException, NotFoundException {
        String wrappedName = ClassAdvisor.notAdvisedMethodName(trans.getClazzName(), trans.getMethod().getName());
        CtMethod wmethod = CtNewMethod.copy((CtMethod)trans.getMethod(), (CtClass)trans.getClazz(), null);
        String originalName = trans.getOriginalName();
        wmethod.setName(wrappedName);
        trans.getClazz().addMethod(wmethod);
        this.moveAnnotationsAndCopySignature(trans.getMethod(), wmethod);
        trans.getMethod().setName(wrappedName);
        Instrumentor.addSyntheticAttribute(trans.getMethod());
        wmethod.setName(originalName);
        trans.setWMethod(wmethod, wrappedName);
        String methodInfoField = this.addMethodInfoFieldToGenAdvisor(trans);
        this.addMethodToGeneratedAdvisor(trans, methodInfoField);
        GeneratedAdvisorMethodExecutionTransformer.getWrapper().prepareForWrapping((CtMember)wmethod, 0);
        if (wrap) {
            GeneratedAdvisorMethodExecutionTransformer.getWrapper().wrap((CtMember)wmethod, 0);
            this.setWrapperBody(trans, methodInfoField);
        }
    }

    protected void doWrap(MethodExecutionTransformer.MethodTransformation trans, String methodInfoFieldName) throws NotFoundException, Exception {
    }

    private void setWrapperBody(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField) throws NotFoundException {
        String code = null;
        String className = GeneratedAdvisorInstrumentor.getAdvisorFQN(trans.getClazz());
        try {
            if (Modifier.isStatic((int)trans.getMethod().getModifiers())) {
                code = "{   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getMethod()) + " ((" + className + ")" + "aop$classAdvisor$aop" + ")." + this.getAdvisorMethodName(trans) + "($$);" + "}";
                trans.setWMethodBody(code);
            } else {
                code = "{   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getMethod()) + " ((" + className + ")" + "getCurrentAdvisor$aop()" + ")." + this.getAdvisorMethodName(trans) + "(this,$$);" + "}";
                trans.setWMethodBody(code);
            }
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            throw new RuntimeException("code was: " + code + " for method " + trans.getOriginalName());
        }
    }

    protected static CtClass[] addTargetToParamsForNonStaticMethod(CtClass outer, CtMethod method) throws NotFoundException {
        CtClass[] params = method.getParameterTypes();
        if (!Modifier.isStatic((int)method.getModifiers())) {
            CtClass[] tempParams = params;
            params = new CtClass[params.length + 1];
            params[0] = outer;
            System.arraycopy(tempParams, 0, params, 1, tempParams.length);
        }
        return params;
    }

    private String getAdvisorMethodName(MethodExecutionTransformer.MethodTransformation trans) {
        if (trans.getHash() >= 0L) {
            return trans.getOriginalName() + trans.getHash();
        }
        return trans.getOriginalName() + "_N_" + Math.abs(trans.getHash());
    }

    private void addMethodToGeneratedAdvisor(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField) throws CannotCompileException, NotFoundException {
        String code = this.createAdvisorMethodBody(trans);
        this.addMethodToGeneratedAdvisor(trans, methodInfoField, code);
    }

    private void addMethodToGeneratedAdvisor(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField, String body) throws CannotCompileException, NotFoundException {
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)trans.getInstrumentor()).getGenadvisor();
        CtClass[] params = GeneratedAdvisorMethodExecutionTransformer.addTargetToParamsForNonStaticMethod(trans.getClazz(), trans.getWMethod());
        String code = this.createAdvisorMethodBody(trans);
        try {
            CtMethod advisorMethod = CtNewMethod.make((int)4, (CtClass)trans.getWMethod().getReturnType(), (String)this.getAdvisorMethodName(trans), (CtClass[])params, (CtClass[])trans.getWMethod().getExceptionTypes(), (String)code, (CtClass)genadvisor);
            genadvisor.addMethod(advisorMethod);
            advisorMethod.setModifiers(Modifier.setProtected((int)advisorMethod.getModifiers()));
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("code was: " + code + " for method " + this.getAdvisorMethodName(trans), e);
        }
    }

    private String createAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException {
        if (Modifier.isStatic((int)trans.getWMethod().getModifiers())) {
            return this.createStaticAdvisorMethodBody(trans);
        }
        return this.createNonStaticAdvisorMethodBody(trans);
    }

    private String createStaticAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException {
        String joinpointName = GeneratedAdvisorMethodExecutionTransformer.getJoinPointFieldName(trans);
        String infoName = GeneratedAdvisorMethodExecutionTransformer.getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
        String code = "{" + GeneratedAdvisorInstrumentor.generateInterceptorChainLockCode(infoName) + "   try" + "   {" + "      if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "      {" + "         if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "         {" + "            super." + "generateJoinPointClass" + "(" + infoName + ");" + "         }" + "      }" + "      if (" + joinpointName + " == null)" + "      { " + "           " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getWMethod()) + trans.getClazzName() + "." + trans.getWrappedName() + "($$);" + "      }" + "      else" + "      {" + "          " + GeneratedAdvisorMethodExecutionTransformer.getAopReturnStr(trans.getWMethod()) + joinpointName + "." + "invokeJoinpoint" + "($$);" + "      }" + "   } finally {" + GeneratedAdvisorInstrumentor.generateInterceptorChainUnlockCode(infoName) + "   }" + "}";
        return code;
    }

    private String createNonStaticAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException {
        String joinpointName = GeneratedAdvisorMethodExecutionTransformer.getJoinPointFieldName(trans);
        String infoName = GeneratedAdvisorMethodExecutionTransformer.getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
        String code = "{" + GeneratedAdvisorInstrumentor.generateInterceptorChainLockCode(infoName) + "   try" + "   {" + "      if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "      {" + "           super." + "generateJoinPointClass" + "(" + infoName + ");" + "      }" + "      if (" + joinpointName + " == null)" + "      { " + "         " + GeneratedAdvisorMethodExecutionTransformer.getAopReturnStr(trans.getWMethod()) + "$1." + trans.getWrappedName() + "(" + GeneratedAdvisorMethodExecutionTransformer.getNonStaticJavasistParamString(trans.getWMethod().getParameterTypes().length) + ");" + "      }" + "      else" + "      {" + "       " + GeneratedAdvisorMethodExecutionTransformer.getAopReturnStr(trans.getWMethod()) + joinpointName + "." + "invokeJoinpoint" + "($$);" + "      }" + "   } finally {" + GeneratedAdvisorInstrumentor.generateInterceptorChainUnlockCode(infoName) + "   }" + "}";
        return code;
    }

    public static String getNonStaticJavasistParamString(long parameterLength) throws NotFoundException {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while ((long)i < parameterLength) {
            if (i > 0) {
                str.append(", ");
            }
            str.append("$" + (i + 2));
            ++i;
        }
        return str.toString();
    }
}

