/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedBeanProperty {
    private Field propertyField;
    private Method propertyGetter;
    private Method propertySetter;
    private String name;
    private boolean isFieldProperty;
    private boolean set = false;

    public TypedBeanProperty(Class<?> cls, Class type) {
        for (Field field : cls.getDeclaredFields()) {
            if (!field.getGenericType().equals(type)) continue;
            this.setupFieldProperty(field);
            this.set = true;
            return;
        }
        for (Field field : cls.getFields()) {
            if (!field.getGenericType().equals(type)) continue;
            this.setupFieldProperty(field);
            this.set = true;
            return;
        }
        for (AccessibleObject accessibleObject : cls.getMethods()) {
            if (!((Method)accessibleObject).getGenericReturnType().equals(type)) continue;
            String methodName = ((Method)accessibleObject).getName();
            if (((Method)accessibleObject).getName().startsWith("get")) {
                this.name = Introspector.decapitalize(((Method)accessibleObject).getName().substring(3));
            } else if (methodName.startsWith("is")) {
                this.name = Introspector.decapitalize(((Method)accessibleObject).getName().substring(2));
            }
            if (this.name != null) {
                this.propertyGetter = Reflections.getGetterMethod(cls, this.name);
                this.propertySetter = Reflections.getSetterMethod(cls, this.name);
                this.isFieldProperty = false;
                this.set = true;
                continue;
            }
            throw new IllegalStateException("Invalid accessor method, must start with 'get' or 'is'.  Method: " + accessibleObject + " in class: " + cls);
        }
    }

    private void setupFieldProperty(Field propertyField) {
        this.propertyField = propertyField;
        this.isFieldProperty = true;
        this.name = propertyField.getName();
    }

    public void setValue(Object bean, Object value) {
        if (this.isFieldProperty) {
            Reflections.setAndWrap(this.propertyField, bean, value);
        } else {
            Reflections.invokeAndWrap(this.propertySetter, bean, value);
        }
    }

    public Object getValue(Object bean) {
        if (this.isFieldProperty) {
            return Reflections.getAndWrap(this.propertyField, bean);
        }
        return Reflections.invokeAndWrap(this.propertyGetter, bean, new Object[0]);
    }

    public String getName() {
        return this.name;
    }

    public boolean isSet() {
        return this.set;
    }
}

