/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.sort;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.plugins.sort.DeployerSorter;
import org.jboss.deployers.plugins.sort.DeployerSorterFactory;
import org.jboss.deployers.plugins.sort.StagedSortedDeployers;
import org.jboss.deployers.spi.deployer.Deployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldStagedSortedDeployers
implements StagedSortedDeployers {
    private Map<String, List<Deployer>> deployersByStage = new HashMap<String, List<Deployer>>();
    private DeployerSorter sorter;

    @Override
    public void addDeployer(String stageName, Deployer deployer) {
        List<Object> deployers = this.deployersByStage.get(stageName);
        if (deployers == null) {
            deployers = Collections.emptyList();
        }
        deployers = this.insert(deployers, deployer);
        this.deployersByStage.put(stageName, deployers);
    }

    @Override
    public List<Deployer> getDeployerList(String stageName) {
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null || deployers.isEmpty()) {
            return Collections.emptyList();
        }
        return deployers;
    }

    @Override
    public void removeDeployer(String stageName, Deployer deployer) {
        List<Deployer> deployers = this.deployersByStage.get(stageName);
        if (deployers == null) {
            return;
        }
        deployers.remove(deployer);
        if (deployers.isEmpty()) {
            this.deployersByStage.remove(stageName);
        }
    }

    protected List<Deployer> insert(List<Deployer> original, Deployer newDeployer) {
        DeployerSorter sorter = this.sorter;
        if (sorter == null) {
            sorter = DeployerSorterFactory.newSorter();
        }
        return sorter.sortDeployers(original, newDeployer);
    }

    public void setSorter(DeployerSorter sorter) {
        this.sorter = sorter;
    }
}

