/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.processor.generator.GeneratorConstants;
import com.sun.tools.ws.processor.generator.GeneratorException;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.ModelVisitor;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Parameter;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Request;
import com.sun.tools.ws.processor.model.Response;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.processor.util.IndentingWriter;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jws.HandlerChain;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class GeneratorBase
implements GeneratorConstants,
ModelVisitor {
    private File destDir;
    private String targetVersion;
    protected boolean donotOverride;
    protected JCodeModel cm;
    protected final Model model;
    protected final String wsdlLocation;
    protected final ErrorReceiver receiver;
    protected final WsimportOptions options;

    protected GeneratorBase(Model model, WsimportOptions options, ErrorReceiver receiver) {
        this.model = model;
        this.options = options;
        this.destDir = options.destDir;
        this.receiver = receiver;
        this.wsdlLocation = options.wsdlLocation;
        this.targetVersion = options.target.getVersion();
        this.cm = options.getCodeModel();
    }

    protected void doGeneration() {
        try {
            this.model.accept(this);
        }
        catch (Exception e) {
            this.receiver.error(e);
        }
    }

    @Override
    public void visit(Model model) throws Exception {
        for (Service service : model.getServices()) {
            service.accept(this);
        }
    }

    @Override
    public void visit(Service service) throws Exception {
        for (Port port : service.getPorts()) {
            port.accept(this);
        }
    }

    @Override
    public void visit(Port port) throws Exception {
        for (Operation operation : port.getOperations()) {
            operation.accept(this);
        }
    }

    @Override
    public void visit(Operation operation) throws Exception {
        Iterator<Fault> faults;
        operation.getRequest().accept(this);
        if (operation.getResponse() != null) {
            operation.getResponse().accept(this);
        }
        if ((faults = operation.getFaultsSet().iterator()) != null) {
            while (faults.hasNext()) {
                Fault fault = faults.next();
                fault.accept(this);
            }
        }
    }

    @Override
    public void visit(Parameter param) throws Exception {
    }

    @Override
    public void visit(Block block) throws Exception {
    }

    @Override
    public void visit(Response response) throws Exception {
    }

    @Override
    public void visit(Request request) throws Exception {
    }

    @Override
    public void visit(Fault fault) throws Exception {
    }

    public List<String> getJAXWSClassComment() {
        return GeneratorBase.getJAXWSClassComment(this.targetVersion);
    }

    public static List<String> getJAXWSClassComment(String targetVersion) {
        ArrayList<String> comments = new ArrayList<String>();
        comments.add("This class was generated by the JAX-WS RI.\n");
        comments.add(ToolVersion.VERSION.BUILD_VERSION + "\n");
        comments.add("Generated source version: " + targetVersion);
        return comments;
    }

    protected JDefinedClass getClass(String className, ClassType type) throws JClassAlreadyExistsException {
        JDefinedClass cls;
        block2: {
            try {
                cls = this.cm._class(className, type);
            }
            catch (JClassAlreadyExistsException e) {
                cls = this.cm._getClass(className);
                if (cls != null) break block2;
                throw e;
            }
        }
        return cls;
    }

    protected void log(String msg) {
        if (this.options.verbose) {
            System.out.println("[" + Names.stripQualifier(this.getClass().getName()) + ": " + msg + "]");
        }
    }

    protected void writeHandlerConfig(String className, JDefinedClass cls, WsimportOptions options) {
        Element e = options.getHandlerChainConfiguration();
        if (e == null) {
            return;
        }
        JAnnotationUse handlerChainAnn = cls.annotate(this.cm.ref(HandlerChain.class));
        NodeList nl = e.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chain");
        if (nl.getLength() > 0) {
            String fName = this.getHandlerConfigFileName(className);
            handlerChainAnn.param("file", fName);
            this.generateHandlerChainFile(e, className);
        }
    }

    private String getHandlerConfigFileName(String fullName) {
        String name = Names.stripQualifier(fullName);
        return name + "_handler.xml";
    }

    private void generateHandlerChainFile(Element hChains, String name) {
        String hcName = this.getHandlerConfigFileName(name);
        File packageDir = DirectoryUtil.getOutputDirectoryFor(name, this.destDir);
        File hcFile = new File(packageDir, hcName);
        this.options.addGeneratedFile(hcFile);
        try {
            IndentingWriter p = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(hcFile)));
            Transformer it = XmlUtil.newTransformer();
            it.setOutputProperty("method", "xml");
            it.setOutputProperty("indent", "yes");
            it.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            it.setOutputProperty("encoding", "UTF-8");
            it.transform(new DOMSource(hChains), new StreamResult(p));
            p.close();
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", e);
        }
    }
}

