/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.EnhancedAccessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistKeyCreator;
import com.sleepycat.persist.impl.RawAccessor;
import com.sleepycat.persist.impl.ReflectionAccessor;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComplexFormat
extends Format {
    private static final long serialVersionUID = -2847843033590454917L;
    private ClassMetadata clsMeta;
    private EntityMetadata entityMeta;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields;
    private List<FieldInfo> nonKeyFields;
    private transient Accessor objAccessor;
    private transient Accessor rawAccessor;
    private transient Format entityFormat;
    private transient Map<String, RawField> rawFields;
    private transient Map<String, FieldAddress> secKeyAddresses;

    ComplexFormat(Class cls, ClassMetadata clsMeta, EntityMetadata entityMeta) {
        super(cls);
        this.clsMeta = clsMeta;
        this.entityMeta = entityMeta;
        this.secKeyFields = new ArrayList<FieldInfo>();
        this.nonKeyFields = FieldInfo.getInstanceFields(cls);
        if (clsMeta.getPrimaryKey() != null) {
            String fieldName = clsMeta.getPrimaryKey().getName();
            FieldInfo field = FieldInfo.getField(this.nonKeyFields, fieldName);
            if (field == null) {
                throw new IllegalArgumentException("Primary key field does not exist: " + this.getClassName() + '.' + fieldName);
            }
            this.nonKeyFields.remove(field);
            this.priKeyField = field;
        }
        if (clsMeta.getSecondaryKeys() != null) {
            for (SecondaryKeyMetadata secKeyMeta : clsMeta.getSecondaryKeys().values()) {
                String fieldName = secKeyMeta.getName();
                FieldInfo field = FieldInfo.getField(this.nonKeyFields, fieldName);
                if (field == null) {
                    throw new IllegalArgumentException("Secondary key field does not exist: " + this.getClassName() + '.' + fieldName);
                }
                Class fieldCls = field.getFieldClass();
                Relationship rel = secKeyMeta.getRelationship();
                if (rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY) {
                    if (!PersistKeyCreator.isManyType(fieldCls)) {
                        throw new IllegalArgumentException("ONE_TO_MANY and MANY_TO_MANY keys must have an array or Collection type: " + this.getClassName() + '.' + fieldName);
                    }
                } else if (PersistKeyCreator.isManyType(fieldCls)) {
                    throw new IllegalArgumentException("ONE_TO_ONE and MANY_TO_ONE keys must not have an array or Collection type: " + this.getClassName() + '.' + fieldName);
                }
                this.nonKeyFields.remove(field);
                this.secKeyFields.add(field);
            }
        }
        Collections.sort(this.secKeyFields);
        Collections.sort(this.nonKeyFields);
    }

    String getPriKeyField() {
        if (this.clsMeta.getPrimaryKey() != null) {
            return this.clsMeta.getPrimaryKey().getName();
        }
        return null;
    }

    @Override
    boolean isEntity() {
        return this.clsMeta.isEntityClass();
    }

    @Override
    boolean isModelClass() {
        return true;
    }

    @Override
    ClassMetadata getClassMetadata() {
        return this.clsMeta;
    }

    @Override
    EntityMetadata getEntityMetadata() {
        return this.entityMeta;
    }

    @Override
    Format getEntityFormat() {
        return this.entityFormat;
    }

    @Override
    public Map<String, RawField> getFields() {
        if (this.rawFields == null) {
            HashMap<String, RawField> map = new HashMap<String, RawField>();
            if (this.priKeyField != null) {
                map.put(this.priKeyField.getName(), this.priKeyField);
            }
            for (FieldInfo field : this.secKeyFields) {
                map.put(field.getName(), field);
            }
            for (FieldInfo field : this.nonKeyFields) {
                map.put(field.getName(), field);
            }
            this.rawFields = map;
        }
        return this.rawFields;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> newFormats) {
        String proxiedClsName;
        Class cls = this.getType();
        if (this.priKeyField != null) {
            this.priKeyField.collectRelatedFormats(catalog, newFormats);
        }
        for (FieldInfo field : this.secKeyFields) {
            field.collectRelatedFormats(catalog, newFormats);
        }
        for (FieldInfo field : this.nonKeyFields) {
            field.collectRelatedFormats(catalog, newFormats);
        }
        Class superCls = cls.getSuperclass();
        if (superCls != Object.class) {
            Format superFormat = catalog.createFormat(superCls, newFormats);
            if (!(superFormat instanceof ComplexFormat)) {
                throw new IllegalArgumentException("The superclass of a complex type must not be a composite key class or a simple type class: " + superCls.getName());
            }
            this.setSuperFormat(superFormat);
        }
        if ((proxiedClsName = this.clsMeta.getProxiedClassName()) != null) {
            Class proxiedCls;
            try {
                proxiedCls = SimpleCatalog.classForName(proxiedClsName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catalog.createFormat(proxiedCls, newFormats);
        }
    }

    @Override
    void initialize(Catalog catalog) {
        Class type = this.getType();
        boolean useEnhanced = EnhancedAccessor.isEnhanced(type);
        if (this.priKeyField != null) {
            this.priKeyField.initialize(catalog);
        }
        for (FieldInfo field : this.secKeyFields) {
            field.initialize(catalog);
        }
        for (FieldInfo field : this.nonKeyFields) {
            field.initialize(catalog);
        }
        ComplexFormat superFormat = (ComplexFormat)this.getSuperFormat();
        if (superFormat != null) {
            superFormat.initializeIfNeeded(catalog);
            Accessor superAccessor = superFormat.objAccessor;
            if (useEnhanced) {
                if (!(superAccessor instanceof EnhancedAccessor)) {
                    throw new IllegalStateException("The superclass of an enhanced class must also  be enhanced: " + superFormat.getClassName());
                }
            } else if (!(superAccessor instanceof ReflectionAccessor)) {
                throw new IllegalStateException("The superclass of an unenhanced class must  not be enhanced: " + superFormat.getClassName());
            }
        }
        EntityMetadata entityMeta = null;
        for (Format format = this; format != null; format = format.getSuperFormat()) {
            if (!format.isEntity()) continue;
            this.entityFormat = format;
            entityMeta = format.getEntityMetadata();
            break;
        }
        if (useEnhanced) {
            this.objAccessor = new EnhancedAccessor(catalog, type, this);
        } else {
            Accessor superObjAccessor = superFormat != null ? superFormat.objAccessor : null;
            this.objAccessor = new ReflectionAccessor(catalog, type, superObjAccessor, this.priKeyField, this.secKeyFields, this.nonKeyFields);
        }
        Accessor superRawAccessor = superFormat != null ? superFormat.rawAccessor : null;
        this.rawAccessor = new RawAccessor(this, superRawAccessor, this.priKeyField, this.secKeyFields, this.nonKeyFields);
        if (entityMeta != null) {
            this.secKeyAddresses = new HashMap<String, FieldAddress>();
            for (SecondaryKeyMetadata secKeyMeta : entityMeta.getSecondaryKeys().values()) {
                String clsName = secKeyMeta.getDeclaringClassName();
                String fieldName = secKeyMeta.getName();
                int superLevel = 0;
                for (ComplexFormat format = this; format != null; format = (ComplexFormat)format.getSuperFormat()) {
                    if (clsName.equals(format.getClassName())) {
                        int fieldNum;
                        boolean isSecField;
                        FieldInfo info = FieldInfo.getField(format.secKeyFields, fieldName);
                        if (info != null) {
                            isSecField = true;
                            fieldNum = format.secKeyFields.indexOf(info);
                        } else {
                            isSecField = false;
                            info = FieldInfo.getField(format.nonKeyFields, fieldName);
                            if (info == null) {
                                throw new IllegalStateException(secKeyMeta.toString());
                            }
                            fieldNum = format.nonKeyFields.indexOf(info);
                        }
                        FieldAddress addr = new FieldAddress(isSecField, fieldNum, superLevel, format, info.getType());
                        this.secKeyAddresses.put(secKeyMeta.getKeyName(), addr);
                    }
                    ++superLevel;
                }
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ComplexFormat) {
            ComplexFormat o = (ComplexFormat)other;
            return super.equals(o) && this.clsMeta.equals(o.clsMeta) && this.nullOrEqual(this.priKeyField, o.priKeyField) && ((Object)this.secKeyFields).equals(o.secKeyFields) && ((Object)this.nonKeyFields).equals(o.nonKeyFields);
        }
        return false;
    }

    private boolean nullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    @Override
    Object newInstance(EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        return accessor.newInstance();
    }

    @Override
    Object newArray(int len) {
        return this.objAccessor.newArray(len);
    }

    @Override
    void writeObject(Object o, EntityOutput output, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.writeSecKeyFields(o, output);
        accessor.writeNonKeyFields(o, output);
    }

    @Override
    void readObject(Object o, EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.readSecKeyFields(o, input, 0, Integer.MAX_VALUE, -1);
        accessor.readNonKeyFields(o, input, 0, Integer.MAX_VALUE, -1);
    }

    @Override
    boolean isPriKeyNullOrZero(Object o, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        return accessor.isPriKeyFieldNullOrZero(o);
    }

    @Override
    void writePriKey(Object o, EntityOutput output, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.writePriKeyField(o, output);
    }

    @Override
    void readPriKey(Object o, EntityInput input, boolean rawAccess) {
        Accessor accessor = rawAccess ? this.rawAccessor : this.objAccessor;
        accessor.readPriKeyField(o, input);
    }

    @Override
    boolean nullifySecKey(Catalog catalog, Object entity, String keyName, Object keyElement) {
        if (this.secKeyAddresses == null) {
            throw new IllegalStateException();
        }
        FieldAddress addr = this.secKeyAddresses.get(keyName);
        if (addr != null) {
            Object oldVal = this.rawAccessor.getField(entity, addr.fieldNum, addr.superLevel, addr.isSecField);
            if (oldVal != null) {
                if (keyElement != null) {
                    boolean isArray;
                    RawObject container = (RawObject)oldVal;
                    Object[] a1 = container.getElements();
                    boolean bl = isArray = a1 != null;
                    if (!isArray) {
                        a1 = CollectionProxy.getElements(container);
                    }
                    if (a1 != null) {
                        for (int i = 0; i < a1.length; ++i) {
                            if (!keyElement.equals(a1[i])) continue;
                            int len = a1.length - 1;
                            Object[] a2 = new Object[len];
                            System.arraycopy(a1, 0, a2, 0, i);
                            System.arraycopy(a1, i + 1, a2, i, len - i);
                            if (isArray) {
                                this.rawAccessor.setField(entity, addr.fieldNum, addr.superLevel, addr.isSecField, new RawObject(container.getType(), a2));
                            } else {
                                CollectionProxy.setElements(container, a2);
                            }
                            return true;
                        }
                    }
                    return false;
                }
                this.rawAccessor.setField(entity, addr.fieldNum, addr.superLevel, addr.isSecField, null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    void skipContents(EntityInput input) {
        this.skipToSecKeyField(input, Integer.MAX_VALUE);
        this.skipToNonKeyField(input, Integer.MAX_VALUE);
    }

    @Override
    void copySecMultiKey(EntityInput input, Format keyFormat, Set results) {
        CollectionProxy.copyElements(input, this, keyFormat, results);
    }

    @Override
    Format skipToSecKey(EntityInput input, String keyName) {
        if (this.secKeyAddresses == null) {
            throw new IllegalStateException();
        }
        FieldAddress addr = this.secKeyAddresses.get(keyName);
        if (addr != null) {
            if (addr.isSecField) {
                addr.clsFormat.skipToSecKeyField(input, addr.fieldNum);
            } else {
                this.skipToSecKeyField(input, Integer.MAX_VALUE);
                addr.clsFormat.skipToNonKeyField(input, addr.fieldNum);
            }
            return addr.keyFormat;
        }
        return null;
    }

    private void skipToSecKeyField(EntityInput input, int toFieldNum) {
        ComplexFormat superFormat = (ComplexFormat)this.getSuperFormat();
        if (superFormat != null) {
            superFormat.skipToSecKeyField(input, Integer.MAX_VALUE);
        }
        int maxNum = Math.min(this.secKeyFields.size(), toFieldNum);
        for (int i = 0; i < maxNum; ++i) {
            input.skipField(this.secKeyFields.get(i).getType());
        }
    }

    private void skipToNonKeyField(EntityInput input, int toFieldNum) {
        ComplexFormat superFormat = (ComplexFormat)this.getSuperFormat();
        if (superFormat != null) {
            superFormat.skipToNonKeyField(input, Integer.MAX_VALUE);
        }
        int maxNum = Math.min(this.nonKeyFields.size(), toFieldNum);
        for (int i = 0; i < maxNum; ++i) {
            input.skipField(this.nonKeyFields.get(i).getType());
        }
    }

    private static class FieldAddress {
        boolean isSecField;
        int fieldNum;
        int superLevel;
        ComplexFormat clsFormat;
        Format keyFormat;

        FieldAddress(boolean isSecField, int fieldNum, int superLevel, ComplexFormat clsFormat, Format keyFormat) {
            this.isSecField = isSecField;
            this.fieldNum = fieldNum;
            this.superLevel = superLevel;
            this.clsFormat = clsFormat;
            this.keyFormat = keyFormat;
        }
    }
}

