/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHCastExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.UtilEvalError;
import java.lang.reflect.Array;

class BSHArrayInitializer
extends SimpleNode {
    BSHArrayInitializer(int n) {
        super(n);
    }

    @Override
    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        throw new EvalError("Array initializer has no base type.", this, callStack);
    }

    public Object eval(Class clazz, int n, CallStack callStack, Interpreter interpreter) throws EvalError {
        int n2 = this.jjtGetNumChildren();
        int[] nArray = new int[n];
        nArray[0] = n2;
        Object object = Array.newInstance(clazz, nArray);
        for (int i = 0; i < n2; ++i) {
            Object object2;
            Object object3;
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(i);
            if (simpleNode instanceof BSHArrayInitializer) {
                if (n < 2) {
                    throw new EvalError("Invalid Location for Intializer, position: " + i, this, callStack);
                }
                object3 = ((BSHArrayInitializer)simpleNode).eval(clazz, n - 1, callStack, interpreter);
            } else {
                object3 = simpleNode.eval(callStack, interpreter);
            }
            if (object3 == Primitive.VOID) {
                throw new EvalError("Void in array initializer, position" + i, this, callStack);
            }
            if (object3 instanceof Primitive) {
                Primitive primitive = (Primitive)object3;
                if (clazz.isPrimitive()) {
                    try {
                        primitive = BSHCastExpression.castPrimitive(primitive, clazz);
                    }
                    catch (UtilEvalError utilEvalError) {
                        utilEvalError.printStackTrace();
                        Interpreter.debug("error:" + utilEvalError);
                        this.throwTypeError(clazz, primitive, i, callStack);
                    }
                }
                object2 = primitive.getValue();
            } else {
                object2 = object3;
            }
            try {
                Array.set(object, i, object2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Interpreter.debug("illegal arg" + illegalArgumentException);
                this.throwTypeError(clazz, object3, i, callStack);
                continue;
            }
            catch (ArrayStoreException arrayStoreException) {
                Interpreter.debug("arraystore" + arrayStoreException);
                this.throwTypeError(clazz, object3, i, callStack);
            }
        }
        return object;
    }

    private void throwTypeError(Class clazz, Object object, int n, CallStack callStack) throws EvalError {
        String string = Reflect.normalizeClassName(clazz);
        String string2 = object instanceof Primitive ? ((Primitive)object).getType().getName() : Reflect.normalizeClassName(object.getClass());
        throw new EvalError("Incompatible type: " + string2 + " in initializer of array type: " + clazz + " at position: " + n, this, callStack);
    }
}

