/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

public class MessageQueueNameHelper {
    private String clientId;
    private String subName;
    private static char ESCAPE = (char)92;
    private static char SEPARATOR_CHAR = (char)46;
    private static String SEPARATOR = ".";

    private MessageQueueNameHelper(String messageQueueName) {
        if (messageQueueName == null) {
            throw new IllegalArgumentException("Message queue name is null");
        }
        StringBuffer[] parts = new StringBuffer[2];
        int currentPart = 0;
        parts[0] = new StringBuffer();
        parts[1] = new StringBuffer();
        int pos = 0;
        while (pos < messageQueueName.length()) {
            char ch = messageQueueName.charAt(pos);
            ++pos;
            if (ch == SEPARATOR_CHAR) {
                if (++currentPart < parts.length) continue;
                throw new IllegalArgumentException("Invalid message queue name: " + messageQueueName);
            }
            if (ch == ESCAPE) {
                if (pos >= messageQueueName.length()) {
                    throw new IllegalArgumentException("Invalid message queue name: " + messageQueueName);
                }
                ch = messageQueueName.charAt(pos);
                ++pos;
            }
            parts[currentPart].append(ch);
        }
        if (currentPart != 1) {
            throw new IllegalArgumentException("Invalid message queue name: " + messageQueueName);
        }
        this.clientId = parts[0].toString();
        this.subName = parts[1].toString();
    }

    private static String escape(String input) {
        return input.replace("\\", "\\\\").replace(".", "\\.");
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSubName() {
        return this.subName;
    }

    public static MessageQueueNameHelper createHelper(String messageQueueName) {
        return new MessageQueueNameHelper(messageQueueName);
    }

    public static String createSubscriptionName(String clientID, String subName) {
        if (clientID == null) {
            throw new IllegalArgumentException("clientID name is null");
        }
        if (subName == null) {
            throw new IllegalArgumentException("Subscription name is null");
        }
        return MessageQueueNameHelper.escape(clientID) + SEPARATOR + MessageQueueNameHelper.escape(subName);
    }
}

