/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import java.io.Serializable;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.message.JBossMessage;
import org.jboss.logging.Logger;

public class MessageProxy
implements Message,
Serializable {
    private static final long serialVersionUID = 5903095946142192468L;
    protected Logger log = Logger.getLogger(MessageProxy.class);
    private transient SessionDelegate delegate;
    private transient boolean cc;
    private int deliveryCount;
    private long deliveryId;
    private transient boolean needToCopyHeader;
    private transient boolean needToCopyBody;
    private transient boolean propertiesReadOnly;
    protected transient boolean bodyReadOnly;
    protected JBossMessage message;
    private Object source;

    public void beforeSend() {
        this.needToCopyHeader = true;
        this.needToCopyBody = true;
        this.propertiesReadOnly = false;
        this.bodyReadOnly = false;
    }

    public MessageProxy() {
    }

    public MessageProxy(JBossMessage message) {
        this.message = message;
        this.needToCopyHeader = false;
        this.needToCopyBody = false;
    }

    public MessageProxy(long deliveryId, JBossMessage message, int deliveryCount) {
        this.deliveryId = deliveryId;
        this.message = message;
        this.deliveryCount = deliveryCount;
        this.needToCopyHeader = true;
        this.needToCopyBody = true;
        this.propertiesReadOnly = true;
        this.bodyReadOnly = true;
    }

    public String getJMSMessageID() throws JMSException {
        return this.message.getJMSMessageID();
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.headerChange();
        this.message.setJMSMessageID(id);
    }

    public long getJMSTimestamp() throws JMSException {
        return this.message.getJMSTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.headerChange();
        this.message.setJMSTimestamp(timestamp);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.message.getJMSCorrelationIDAsBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.headerChange();
        this.message.setJMSCorrelationIDAsBytes(correlationID);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.headerChange();
        this.message.setJMSCorrelationID(correlationID);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.message.getJMSCorrelationID();
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.message.getJMSReplyTo();
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this.headerChange();
        this.message.setJMSReplyTo(replyTo);
    }

    public Destination getJMSDestination() throws JMSException {
        return this.message.getJMSDestination();
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.headerChange();
        this.message.setJMSDestination(destination);
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.message.getJMSDeliveryMode();
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this.headerChange();
        this.message.setJMSDeliveryMode(deliveryMode);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.deliveryCount >= 2;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (this.deliveryCount == 1) {
            ++this.deliveryCount;
        }
    }

    public String getJMSType() throws JMSException {
        return this.message.getJMSType();
    }

    public void setJMSType(String type) throws JMSException {
        this.headerChange();
        this.message.setJMSType(type);
    }

    public long getJMSExpiration() throws JMSException {
        return this.message.getJMSExpiration();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.headerChange();
        this.message.setJMSExpiration(expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this.message.getJMSPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.headerChange();
        this.message.setJMSPriority(priority);
    }

    public void clearProperties() throws JMSException {
        this.headerChange();
        this.message.clearProperties();
        this.propertiesReadOnly = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.message.propertyExists(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this.message.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this.message.getByteProperty(name);
    }

    public short getShortProperty(String name) throws JMSException {
        return this.message.getShortProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return this.deliveryCount;
        }
        return this.message.getIntProperty(name);
    }

    public long getLongProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return this.deliveryCount;
        }
        return this.message.getLongProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this.message.getFloatProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this.message.getDoubleProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        if ("JMSXDeliveryCount".equals(name)) {
            return Integer.toString(this.deliveryCount);
        }
        return this.message.getStringProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this.message.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.message.getPropertyNames();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setByteProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setShortProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setLongProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setFloatProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setDoubleProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setStringProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.propertiesReadOnly) {
            throw new MessageNotWriteableException("Properties are read-only");
        }
        this.headerChange();
        this.message.setObjectProperty(name, value);
    }

    public void acknowledge() throws JMSException {
        if (!this.cc) {
            this.delegate.acknowledgeAll();
        }
    }

    public void clearBody() throws JMSException {
        this.bodyChange();
        this.message.clearBody();
        this.bodyReadOnly = false;
    }

    public void setSessionDelegate(SessionDelegate sd, boolean isConnectionConsumer) {
        this.delegate = sd;
        this.cc = isConnectionConsumer;
    }

    public SessionDelegate getSessionDelegate() {
        return this.delegate;
    }

    public JBossMessage getMessage() {
        return this.message;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public void incDeliveryCount() {
        ++this.deliveryCount;
    }

    public long getDeliveryId() {
        return this.deliveryId;
    }

    public String toString() {
        return "delegator->" + this.message + ", deliveryId=" + this.deliveryId;
    }

    protected void headerChange() throws JMSException {
        if (this.needToCopyHeader) {
            this.copyMessage();
        }
    }

    protected void bodyChange() throws JMSException {
        if (this.needToCopyBody) {
            this.headerChange();
            this.message.copyPayload(this.message.getPayload());
            this.needToCopyBody = false;
        }
    }

    private void copyMessage() throws JMSException {
        this.message = this.message.doCopy();
        this.needToCopyHeader = false;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }
}

