/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.sort;

import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HumaneStringComparator
implements Comparator<String> {
    Pattern SEGMENT_PATTERN = Pattern.compile("(\\d+(\\.\\d+)?|\\D+)");
    public static final HumaneStringComparator DEFAULT = new HumaneStringComparator();

    @Override
    public int compare(String lhs, String rhs) {
        if (lhs == null && rhs == null) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        Matcher lhsMatcher = this.SEGMENT_PATTERN.matcher(lhs);
        Matcher rhsMatcher = this.SEGMENT_PATTERN.matcher(rhs);
        int result = 0;
        while (result == 0) {
            boolean lhsFound = lhsMatcher.find();
            boolean rhsFound = rhsMatcher.find();
            if (!lhsFound && !rhsFound) {
                return lhs.compareTo(rhs);
            }
            if (!lhsFound) {
                result = -1;
                continue;
            }
            if (!rhsFound) {
                result = 1;
                continue;
            }
            String lhsSegment = lhsMatcher.group();
            String rhsSegment = rhsMatcher.group();
            if (Character.isDigit(lhsSegment.toCharArray()[0]) && Character.isDigit(rhsSegment.toCharArray()[0])) {
                result = this.compareNumberSegments(lhsSegment, rhsSegment);
                continue;
            }
            result = this.compareStringSegments(lhsSegment, rhsSegment);
        }
        return result;
    }

    protected int compareNumberSegments(String lhs, String rhs) {
        return new Double(lhs).compareTo(new Double(rhs));
    }

    protected int compareStringSegments(String lhs, String rhs) {
        return lhs.compareToIgnoreCase(rhs);
    }
}

