/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.AntClassLoader;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.util.FileManager;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xdoclet.util.XDocletUtilMessages;

public class XmlValidator
extends DefaultHandler {
    public static final String DEFAULT_XML_READER_CLASSNAME = "org.apache.crimson.parser.XMLReaderImpl";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static XmlValidator instance = new XmlValidator(null);
    protected ClassLoader classLoader;
    protected XMLReader xmlReader = null;
    protected String readerClassName = "org.apache.crimson.parser.XMLReaderImpl";
    private final HashMap _dtds = new HashMap();
    private final Collection _schemas = new ArrayList();

    public XmlValidator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static XmlValidator getInstance() {
        return instance;
    }

    public static void setInstance(XmlValidator instance) {
        XmlValidator.instance = instance;
    }

    public void registerDTD(String publicId, URL dtdURL) {
        Log log = LogUtil.getLog(XmlValidator.class, "registerDTD");
        if (log.isDebugEnabled()) {
            log.debug((Object)("DTD '" + dtdURL + "' registered for public Id '" + publicId + "'."));
        }
        this._dtds.put(publicId, dtdURL);
    }

    public void registerSchema(URL schemaURL) {
        Log log = LogUtil.getLog(XmlValidator.class, "registerSchema");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Schema '" + schemaURL + "' registered."));
        }
        this._schemas.add(schemaURL.toString());
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        URL dtdURL;
        Log log = LogUtil.getLog(XmlValidator.class, "resolveEntity");
        if (log.isDebugEnabled()) {
            log.debug((Object)("publicId=" + publicId));
            log.debug((Object)("systemId=" + systemId));
        }
        if ((dtdURL = (URL)this._dtds.get(publicId)) != null) {
            String dtd = FileManager.getURLContent(dtdURL);
            if (log.isDebugEnabled()) {
                log.debug((Object)("dtdURL != null, dtdURL=" + dtdURL));
                log.debug((Object)("dtd.length()=" + dtd.length()));
            }
            return new InputSource(new StringReader(dtd));
        }
        log.debug((Object)"dtdURL == null");
        String msg = Translator.getString(XDocletMessages.class, "COULDNT_LOAD_LOCAL_DTD", new String[]{publicId});
        if (this.isSchemaValidation()) {
            log.debug((Object)msg);
        } else {
            log.error((Object)msg);
        }
        return null;
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    @Override
    public void warning(SAXParseException e) throws SAXParseException {
    }

    public void validate(File xmlFile) throws XDocletException {
        if (this.classLoader == null) {
            this.initValidator();
        } else {
            this.initValidatorHack();
        }
        this.doValidate(xmlFile);
    }

    public void reset() {
        this._schemas.clear();
        this._dtds.clear();
    }

    private boolean isSchemaValidation() {
        return !this._schemas.isEmpty();
    }

    private void doValidate(File xml_file) throws XDocletException {
        Log log = LogUtil.getLog(XmlValidator.class, "doValidate");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validating " + xml_file.getName() + "... "));
            }
            InputSource is = new InputSource(new FileReader(xml_file));
            String uri = "file:" + xml_file.getAbsolutePath().replace('\\', '/');
            int index = uri.indexOf(35);
            while (index != -1) {
                uri = uri.substring(0, index) + "%23" + uri.substring(index + 1);
                index = uri.indexOf(35);
            }
            is.setSystemId(uri);
            this.xmlReader.parse(is);
        }
        catch (SAXParseException e) {
            String message = Translator.getString(XDocletUtilMessages.class, "GENERATED_XML_INVALID", new String[]{e.getSystemId(), Integer.toString(e.getLineNumber()), e.getMessage()});
            throw new XDocletException(e, message);
        }
        catch (SAXException e) {
            String message = Translator.getString(XDocletUtilMessages.class, "PARSING_FAILED", new String[]{xml_file.getAbsolutePath(), e.getMessage()});
            throw new XDocletException(e, message);
        }
        catch (IOException e) {
            String message = Translator.getString(XDocletUtilMessages.class, "PARSING_FAILED", new String[]{xml_file.getAbsolutePath(), e.getMessage()});
            throw new XDocletException(e, message);
        }
    }

    private void initValidatorHack() throws XDocletException {
        block15: {
            Log log = LogUtil.getLog(XmlValidator.class, "initValidator");
            if (this.isSchemaValidation()) {
                log.warn((Object)Translator.getString(XDocletUtilMessages.class, "PARSER_DOES_NOT_SUPPORT_XSD_VALIDATION"));
            }
            try {
                Class<?> readerClass = null;
                if (this.classLoader != null) {
                    readerClass = this.classLoader.loadClass(this.readerClassName);
                    AntClassLoader.initializeClass(readerClass);
                } else {
                    readerClass = Class.forName(this.readerClassName);
                }
                if (XMLReader.class.isAssignableFrom(readerClass)) {
                    this.xmlReader = (XMLReader)readerClass.newInstance();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using SAX2 reader " + this.readerClassName));
                    }
                    break block15;
                }
                if (Parser.class.isAssignableFrom(readerClass)) {
                    Parser parser = (Parser)readerClass.newInstance();
                    this.xmlReader = new ParserAdapter(parser);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Using SAX1 parser " + this.readerClassName));
                    }
                    break block15;
                }
                String message = Translator.getString(XDocletUtilMessages.class, "INIT_FAILED", new String[]{this.readerClassName});
                System.out.println("init_failed");
                throw new XDocletException(message);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                String message = Translator.getString(XDocletUtilMessages.class, "INIT_FAILED", new String[]{this.readerClassName});
                throw new XDocletException(e, message);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                String message = Translator.getString(XDocletUtilMessages.class, "INIT_FAILED", new String[]{this.readerClassName});
                throw new XDocletException(e, message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                String message = Translator.getString(XDocletUtilMessages.class, "INIT_FAILED", new String[]{this.readerClassName});
                throw new XDocletException(e, message);
            }
        }
        this.xmlReader.setEntityResolver(this);
        if (!(this.xmlReader instanceof ParserAdapter)) {
            try {
                this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXNotRecognizedException e) {
                e.printStackTrace();
            }
            catch (SAXNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    private void initValidator() throws XDocletException {
        Log log = LogUtil.getLog(XmlValidator.class, "initValidator");
        try {
            SAXParser parser;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(this.isSchemaValidation());
            try {
                parser = factory.newSAXParser();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SAX Parser crated class=" + parser.getClass()));
                }
            }
            catch (ParserConfigurationException e) {
                if (!factory.isNamespaceAware()) {
                    throw e;
                }
                factory.setNamespaceAware(false);
                parser = factory.newSAXParser();
                log.warn((Object)Translator.getString(XDocletUtilMessages.class, "NO_NAMESPACE_AWARE_SAX_PARSER"));
            }
            if (this.isSchemaValidation() && parser.isNamespaceAware()) {
                try {
                    parser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                    parser.setProperty(JAXP_SCHEMA_SOURCE, this._schemas.toArray(new String[this._schemas.size()]));
                }
                catch (SAXException e) {
                    factory.setValidating(false);
                    parser = factory.newSAXParser();
                    log.warn((Object)Translator.getString(XDocletUtilMessages.class, "PARSER_DOES_NOT_SUPPORT_XSD_VALIDATION"));
                    log.debug((Object)"JAXP 1.2 schema validation properties not recognized", (Throwable)e);
                }
            }
            this.xmlReader = parser.getXMLReader();
            this.xmlReader.setEntityResolver(this);
            this.xmlReader.setErrorHandler(this);
        }
        catch (SAXException e) {
            throw new XDocletException(e, Translator.getString(XDocletMessages.class, "COULDNT_INIT_XML_PARSER"));
        }
        catch (ParserConfigurationException e) {
            throw new XDocletException(e, Translator.getString(XDocletMessages.class, "COULDNT_CONF_XML_PARSER"));
        }
        catch (NullPointerException e) {
            throw new XDocletException(e, Translator.getString(XDocletMessages.class, "COULDNT_LOAD_DTD"));
        }
    }
}

