/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap.standalone;

import java.net.URL;
import java.util.Enumeration;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;

public class StandaloneBootstrap
extends BasicBootstrap {
    protected BasicXMLDeployer deployer;
    protected String[] args;

    public static void main(String[] args) throws Exception {
        StandaloneBootstrap bootstrap = new StandaloneBootstrap(args);
        bootstrap.run();
    }

    public StandaloneBootstrap(String[] args) throws Exception {
        this.args = args;
    }

    public void bootstrap() throws Throwable {
        URL url;
        super.bootstrap();
        this.deployer = new BasicXMLDeployer(this.getKernel());
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> e = cl.getResources("jboss-beans.xml");
        while (e.hasMoreElements()) {
            url = e.nextElement();
            this.deploy(url);
        }
        e = cl.getResources("META-INF/jboss-beans.xml");
        while (e.hasMoreElements()) {
            url = e.nextElement();
            this.deploy(url);
        }
        this.deployer.validate();
    }

    protected void deploy(URL url) throws Throwable {
        this.deployer.deploy(url);
    }

    protected void undeploy(URL url) {
        try {
            this.deployer.undeploy(url);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during undeployment: " + url), t);
        }
    }

    protected class Shutdown
    extends Thread {
        protected Shutdown() {
        }

        public void run() {
            StandaloneBootstrap.this.log.info((Object)"Shutting down");
            StandaloneBootstrap.this.deployer.shutdown();
        }
    }
}

