/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.core.buffers.impl.ResetLimitWrappedHornetQBuffer;
import org.hornetq.core.client.impl.ClientLargeMessageInternal;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.client.impl.LargeMessageController;

public class ClientLargeMessageImpl
extends ClientMessageImpl
implements ClientLargeMessageInternal {
    private LargeMessageController largeMessageController;
    private long largeMessageSize;

    public long getLargeMessageSize() {
        return this.largeMessageSize;
    }

    public void setLargeMessageSize(long largeMessageSize) {
        this.largeMessageSize = largeMessageSize;
    }

    public int getEncodeSize() {
        if (this.bodyBuffer != null) {
            return super.getEncodeSize();
        }
        return 8 + this.getHeadersAndPropertiesEncodeSize();
    }

    public boolean isLargeMessage() {
        return true;
    }

    public void setLargeMessageController(LargeMessageController controller) {
        this.largeMessageController = controller;
    }

    public HornetQBuffer getBodyBuffer() {
        this.checkBuffer();
        return this.bodyBuffer;
    }

    public int getBodySize() {
        return this.getLongProperty(Message.HDR_LARGE_BODY_SIZE).intValue();
    }

    public LargeMessageController getLargeMessageController() {
        return this.largeMessageController;
    }

    public void saveToOutputStream(OutputStream out) throws HornetQException {
        if (this.bodyBuffer != null) {
            super.saveToOutputStream(out);
        } else {
            this.largeMessageController.saveBuffer(out);
        }
    }

    public void setOutputStream(OutputStream out) throws HornetQException {
        if (this.bodyBuffer != null) {
            super.setOutputStream(out);
        } else {
            this.largeMessageController.setOutputStream(out);
        }
    }

    public boolean waitOutputStreamCompletion(long timeMilliseconds) throws HornetQException {
        if (this.bodyBuffer != null) {
            return super.waitOutputStreamCompletion(timeMilliseconds);
        }
        return this.largeMessageController.waitCompletion(timeMilliseconds);
    }

    public void discardBody() {
        if (this.bodyBuffer != null) {
            super.discardBody();
        } else {
            this.largeMessageController.discardUnusedPackets();
        }
    }

    private void checkBuffer() {
        if (this.bodyBuffer == null) {
            long bodySize = this.largeMessageSize + 17L;
            if (bodySize > Integer.MAX_VALUE) {
                bodySize = Integer.MAX_VALUE;
            }
            this.createBody((int)bodySize);
            this.bodyBuffer = new ResetLimitWrappedHornetQBuffer(17, this.buffer, this);
            try {
                this.largeMessageController.saveBuffer(new HornetQOutputStream(this.bodyBuffer));
            }
            catch (HornetQException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected class HornetQOutputStream
    extends OutputStream {
        HornetQBuffer bufferOut;

        HornetQOutputStream(HornetQBuffer out) {
            this.bufferOut = out;
        }

        public void write(int b) throws IOException {
            this.bufferOut.writeByte((byte)(b & 0xFF));
        }
    }
}

