/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.NonOptimizedCallerTransformer;
import org.jboss.aop.instrument.NonOptimizedConstructionTransformer;
import org.jboss.aop.instrument.NonOptimizedConstructorExecutionTransformer;
import org.jboss.aop.instrument.NonOptimizedFieldAccessTransformer;
import org.jboss.aop.instrument.NonOptimizedMethodExecutionTransformer;
import org.jboss.aop.instrument.OptimizedCallerTransformer;
import org.jboss.aop.instrument.OptimizedConstructionTransformer;
import org.jboss.aop.instrument.OptimizedConstructorExecutionTransformer;
import org.jboss.aop.instrument.OptimizedFieldAccessTransformer;
import org.jboss.aop.instrument.OptimizedMethodExecutionTransformer;

public class ClassicInstrumentor
extends Instrumentor {
    public static final String HELPER_CLASS_NAME = Instrumentor.AOP_PACKAGE + ".ClassAdvisor";

    public ClassicInstrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer) {
        super(pool, manager, joinpointClassifier, observer);
    }

    public ClassicInstrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier) {
        super(manager, joinpointClassifier);
    }

    protected void intitialiseTransformers() {
        if (AspectManager.optimize) {
            this.methodExecutionTransformer = new OptimizedMethodExecutionTransformer(this);
            this.constructorExecutionTransformer = new OptimizedConstructorExecutionTransformer(this);
            this.fieldAccessTransformer = new OptimizedFieldAccessTransformer(this);
            this.constructionTransformer = new OptimizedConstructionTransformer(this);
            this.callerTransformer = new OptimizedCallerTransformer(this, this.manager);
        } else {
            this.methodExecutionTransformer = new NonOptimizedMethodExecutionTransformer(this);
            this.constructorExecutionTransformer = new NonOptimizedConstructorExecutionTransformer(this);
            this.fieldAccessTransformer = new NonOptimizedFieldAccessTransformer(this);
            this.constructionTransformer = new NonOptimizedConstructionTransformer(this);
            this.callerTransformer = new NonOptimizedCallerTransformer(this, this.manager);
        }
    }

    protected CtMethod createMixinInvokeMethod(CtClass clazz, CtClass mixinClass, String initializer, CtMethod method, long hash) throws CannotCompileException, NotFoundException, Exception {
        String code = null;
        String aopReturnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ";
        String args = "null";
        if (method.getParameterTypes().length > 0) {
            args = "$args";
        }
        code = "{ " + returnStr + " " + ClassicInstrumentor.mixinFieldName(mixinClass) + "." + method.getName() + "($$); " + "}";
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
        CtMethod nmethod = CtNewMethod.make((CtClass)method.getReturnType(), (String)wrappedName, (CtClass[])method.getParameterTypes(), (CtClass[])method.getExceptionTypes(), (String)code, (CtClass)clazz);
        int modifier = method.getModifiers();
        if ((modifier & 0x400) == 1024) {
            modifier &= 0xFFFFFBFF;
        }
        nmethod.setModifiers(modifier);
        ClassicInstrumentor.addSyntheticAttribute(nmethod);
        clazz.addMethod(nmethod);
        code = "{    if (" + ClassicInstrumentor.mixinFieldName(mixinClass) + " == null) { " + "      this." + ClassicInstrumentor.mixinFieldName(mixinClass) + " = " + initializer + "; " + "   } " + "   org.jboss.aop.ClassInstanceAdvisor instAdv = (org.jboss.aop.ClassInstanceAdvisor)_getInstanceAdvisor();" + "   if (" + "aop$classAdvisor$aop" + ".hasAspects() || (instAdv != null && instAdv.hasInstanceAspects)) " + "   { " + "      Object[] ags = " + args + "; " + "      " + aopReturnStr + "aop$classAdvisor$aop" + ".invokeMethod(instAdv, this, " + hash + "L, ags); " + "   } " + "   else " + "   {" + "      " + returnStr + " " + ClassicInstrumentor.mixinFieldName(mixinClass) + "." + method.getName() + "($$); " + "   }" + "}";
        CtMethod wmethod = CtNewMethod.make((CtClass)method.getReturnType(), (String)method.getName(), (CtClass[])method.getParameterTypes(), (CtClass[])method.getExceptionTypes(), (String)code, (CtClass)clazz);
        wmethod.setModifiers(modifier);
        clazz.addMethod(wmethod);
        return wmethod;
    }

    protected void doSetupBasics(CtClass clazz) throws CannotCompileException, NotFoundException {
        this.addHelperClass(clazz);
        if (this.isBaseClass(clazz)) {
            this.addBaseElements(clazz);
        }
    }

    private void addHelperField(CtClass clazz) throws CannotCompileException, NotFoundException {
        String className = clazz.getName();
        this.addStaticField(clazz, "aop$classAdvisor$aop", HELPER_CLASS_NAME, CtField.Initializer.byExpr((String)(ASPECT_MANAGER_CLASS_NAME + "#instance(java.lang.Class#forName(\"" + className + "\")).getAdvisor(java.lang.Class#forName(\"" + className + "\"))")));
    }

    private void addHelperClass(CtClass clazz) throws CannotCompileException, NotFoundException {
        this.addHelperField(clazz);
        CtMethod getter = CtNewMethod.make((String)"public org.jboss.aop.Advisor _getAdvisor(){     return aop$classAdvisor$aop;}", (CtClass)clazz);
        ClassicInstrumentor.addSyntheticAttribute(getter);
        clazz.addMethod(getter);
    }

    private void addBaseElements(CtClass clazz) throws NotFoundException, CannotCompileException {
        this.addProtectedField(clazz, "_instanceAdvisor", "org.jboss.aop.ClassInstanceAdvisor", null);
        CtMethod getter = CtNewMethod.make((String)"public org.jboss.aop.InstanceAdvisor _getInstanceAdvisor(){     synchronized(this) {       if (_instanceAdvisor == null) { _instanceAdvisor = new org.jboss.aop.ClassInstanceAdvisor(this); }       return _instanceAdvisor;    } }", (CtClass)clazz);
        ClassicInstrumentor.addSyntheticAttribute(getter);
        clazz.addMethod(getter);
        CtMethod setter = CtNewMethod.make((String)"public void _setInstanceAdvisor(org.jboss.aop.InstanceAdvisor newAdvisor){     synchronized(this) {       _instanceAdvisor = (org.jboss.aop.ClassInstanceAdvisor)newAdvisor;    } }", (CtClass)clazz);
        ClassicInstrumentor.addSyntheticAttribute(setter);
        clazz.addMethod(setter);
    }
}

