/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.util;

import java.util.LinkedList;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.gui.configuration.helper.ConfigurationUtility;

public class PropertyIdGeneratorUtility {
    private static final String ID_PREFIX = "rhq_prop-";
    private static final String ID_DELIMITER = "_";

    public static String getIdentifier(Property property, Integer index) {
        String suffix = null;
        return PropertyIdGeneratorUtility.getIdentifier(property, index, suffix);
    }

    public static String getIdentifier(Property property, Integer index, String suffix) {
        if (property == null) {
            throw new IllegalArgumentException("Property parameter cannot be null.");
        }
        LinkedList<Property> propertyHierarchy = ConfigurationUtility.getPropertyHierarchy(property);
        StringBuilder identifier = new StringBuilder(ID_PREFIX);
        Configuration configuration = propertyHierarchy.getFirst().getConfiguration();
        int configId = configuration.getId() != 0 ? configuration.getId() : configuration.hashCode();
        identifier.append(configId);
        for (Property propertyNode : propertyHierarchy) {
            identifier.append(ID_DELIMITER).append(propertyNode.getName().hashCode());
            if (propertyNode.getParentList() == null) continue;
            if (index == null) {
                throw new IllegalStateException("Property " + property + " has a list in its ancestry, but no index was provided.");
            }
            identifier.append(ID_DELIMITER).append(index);
        }
        if (suffix != null) {
            identifier.append(suffix);
        }
        return identifier.toString();
    }

    public static String getIdentifier(Configuration configuration, String suffix) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration parameter cannot be null.");
        }
        StringBuilder identifier = new StringBuilder(ID_PREFIX);
        int configId = configuration.getId() != 0 ? configuration.getId() : configuration.hashCode();
        identifier.append(configId);
        if (suffix != null) {
            identifier.append(suffix);
        }
        return identifier.toString();
    }
}

