/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.stomp.StompDecoder;
import org.hornetq.core.protocol.stomp.StompProtocolManager;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;

public class StompConnection
implements RemotingConnection {
    private static final Logger log = Logger.getLogger(StompConnection.class);
    private final StompProtocolManager manager;
    private final Connection transportConnection;
    private String login;
    private String passcode;
    private String clientID;
    private boolean valid;
    private boolean destroyed = false;
    private final long creationTime;
    private StompDecoder decoder = new StompDecoder();
    private final Acceptor acceptorUsed;
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private final Object failLock = new Object();
    private volatile boolean dataReceived;

    public StompDecoder getDecoder() {
        return this.decoder;
    }

    StompConnection(Acceptor acceptorUsed, Connection transportConnection, StompProtocolManager manager) {
        this.transportConnection = transportConnection;
        this.manager = manager;
        this.creationTime = System.currentTimeMillis();
        this.acceptorUsed = acceptorUsed;
    }

    @Override
    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        this.failureListeners.add(listener);
    }

    @Override
    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        return this.failureListeners.remove(listener);
    }

    @Override
    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        this.closeListeners.add(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        return this.closeListeners.remove(listener);
    }

    @Override
    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    @Override
    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    @Override
    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    @Override
    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    public void setDataReceived() {
        this.dataReceived = true;
    }

    @Override
    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    @Override
    public HornetQBuffer createBuffer(int size) {
        return HornetQBuffers.dynamicBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
        }
        this.destroyed = true;
        this.internalClose();
        this.callClosingListeners();
    }

    Acceptor getAcceptorUsed() {
        return this.acceptorUsed;
    }

    private void internalClose() {
        this.transportConnection.close();
        this.manager.cleanup(this);
    }

    @Override
    public void disconnect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(HornetQException me) {
        Object object = this.failLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
        }
        log.warn("Connection failure has been detected: " + me.getMessage() + " [code=" + me.getCode() + "]");
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.internalClose();
    }

    @Override
    public void flush() {
    }

    @Override
    public List<FailureListener> getFailureListeners() {
        return Collections.emptyList();
    }

    @Override
    public Object getID() {
        return this.transportConnection.getID();
    }

    @Override
    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        this.manager.handleBuffer(this, buffer);
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return this.login;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    private void callFailureListeners(HornetQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                log.error("Failed to execute failure listener", t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                log.error("Failed to execute failure listener", t);
            }
        }
    }
}

