/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentContextMBean;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentUnit;
import org.jboss.deployers.vfs.plugins.structure.MetaDataMatchFilter;
import org.jboss.deployers.vfs.plugins.structure.SecurityActions;
import org.jboss.deployers.vfs.plugins.structure.VFSDeploymentResourceLoaderImpl;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentResourceLoader;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractVFSDeploymentContext
extends AbstractDeploymentContext
implements VFSDeploymentContext,
AbstractVFSDeploymentContextMBean {
    private static final long serialVersionUID = 4474515937180482776L;
    private static final Logger log = Logger.getLogger(AbstractVFSDeploymentContext.class);
    private VirtualFile root;
    private List<VirtualFile> metaDataLocations;
    private List<VirtualFile> classPath;
    private transient VFSDeploymentResourceLoader loader;

    static final String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            return root.toURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public AbstractVFSDeploymentContext() {
    }

    public AbstractVFSDeploymentContext(String name, String simpleName, VirtualFile root, String relativePath) {
        super(name, simpleName, relativePath);
        this.root = root;
    }

    public AbstractVFSDeploymentContext(VirtualFile root, String relativePath) {
        super(AbstractVFSDeploymentContext.safeVirtualFileName(root), root.getName(), relativePath);
        this.root = root;
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    public void setMetaDataPath(List<String> paths) {
        if (paths == null) {
            this.setMetaDataLocations(null);
            return;
        }
        try {
            ArrayList<VirtualFile> locations = new ArrayList<VirtualFile>();
            for (String path : paths) {
                if (path == null) {
                    throw new IllegalArgumentException("Null path in paths: " + paths);
                }
                VirtualFile child = this.root.getChild(path);
                if (child != null) {
                    locations.add(child);
                    continue;
                }
                log.debug((Object)("Meta data path does not exist: root=" + this.root.getPathName() + " path=" + path));
            }
            this.setMetaDataLocations(locations);
        }
        catch (IOException e) {
            log.warn((Object)("Exception while applying paths: root=" + this.root.getPathName() + " paths=" + paths));
        }
    }

    protected List<VirtualFile> getMutableMetaDataLocations() {
        return this.metaDataLocations;
    }

    @Override
    public List<VirtualFile> getMetaDataLocations() {
        if (this.metaDataLocations == null || this.metaDataLocations.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.metaDataLocations);
    }

    public void setMetaDataLocations(List<VirtualFile> locations) {
        this.metaDataLocations = locations;
    }

    public VirtualFile getMetaDataFile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        try {
            if (this.metaDataLocations == null || this.metaDataLocations.isEmpty()) {
                String fileName;
                if (this.root != null && SecurityActions.isLeaf(this.root) && (fileName = this.root.getName()).equals(name)) {
                    return this.root;
                }
                return null;
            }
            return this.searchMetaDataLocations(name);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Error retrieving meta data: " + name + " reason=" + e));
            }
            return null;
        }
    }

    protected VirtualFile searchMetaDataLocations(String name) {
        VirtualFile result = null;
        for (VirtualFile location : this.getMetaDataLocations()) {
            try {
                result = location.getChild(name);
                if (result == null) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Found " + name + " in " + location.getName()));
                }
                this.deployed();
                break;
            }
            catch (IOException e) {
                log.debug((Object)("Search exception invocation for metafile " + name + " in " + location.getName() + ", reason: " + e));
            }
        }
        return result;
    }

    public List<VirtualFile> getMetaDataFiles(String name, String suffix) {
        if (name == null && suffix == null) {
            throw new IllegalArgumentException("Null name and suffix");
        }
        MetaDataMatchFilter filter = new MetaDataMatchFilter(name, suffix);
        return this.getMetaDataFiles((VirtualFileFilter)filter);
    }

    public List<VirtualFile> getMetaDataFiles(VirtualFileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        try {
            if (this.metaDataLocations == null || this.metaDataLocations.isEmpty()) {
                if (this.root != null && SecurityActions.isLeaf(this.root) && filter.accepts(this.root)) {
                    return Collections.singletonList(this.root);
                }
                return Collections.emptyList();
            }
            ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
            for (VirtualFile location : this.metaDataLocations) {
                List result = location.getChildren(filter);
                if (result == null || result.isEmpty()) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Found results with " + filter + " in " + location.getName()));
                }
                results.addAll(result);
                this.deployed();
            }
            return results;
        }
        catch (Exception e) {
            log.debug((Object)("Error retrieving meta data: filter=" + filter), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void prependMetaDataLocation(VirtualFile ... locations) {
        if (locations == null) {
            throw new IllegalArgumentException("Null locations");
        }
        List<VirtualFile> metadataLocations = this.getMutableMetaDataLocations();
        if (metadataLocations == null) {
            metadataLocations = new ArrayList<VirtualFile>();
        }
        for (int i = locations.length - 1; i >= 0; --i) {
            VirtualFile location = locations[i];
            if (location == null) {
                throw new IllegalArgumentException("Null virtual file in " + Arrays.toString(locations));
            }
            metadataLocations.add(0, location);
        }
        this.setMetaDataLocations(metadataLocations);
    }

    public void appendMetaDataLocation(VirtualFile ... locations) {
        if (locations == null) {
            throw new IllegalArgumentException("Null location");
        }
        List<VirtualFile> metaDataLocations = this.getMutableMetaDataLocations();
        if (metaDataLocations == null) {
            metaDataLocations = new ArrayList<VirtualFile>();
        }
        for (VirtualFile location : locations) {
            if (location == null) {
                throw new IllegalArgumentException("Null virtual file in " + Arrays.toString(locations));
            }
            metaDataLocations.add(location);
        }
        this.setMetaDataLocations(metaDataLocations);
    }

    public void removeMetaDataLocation(VirtualFile ... locations) {
        if (locations == null || locations.length == 0) {
            return;
        }
        for (VirtualFile location : locations) {
            this.metaDataLocations.remove(location);
        }
    }

    public VirtualFile getFile(String name) {
        return this.getResourceLoader().getFile(name);
    }

    protected List<VirtualFile> getMutableClassPath() {
        return this.classPath;
    }

    @Override
    public List<VirtualFile> getClassPath() {
        if (this.classPath == null || this.classPath.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.classPath);
    }

    public void setClassPath(List<VirtualFile> paths) {
        this.classPath = paths;
        if (log.isTraceEnabled() && paths != null) {
            log.trace((Object)("ClassPath for " + this.root.getPathName() + " is " + VFSUtils.getPathsString(paths)));
        }
    }

    public void appendClassPath(List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException("Null files");
        }
        List<VirtualFile> classPath = this.getMutableClassPath();
        if (classPath == null) {
            classPath = new ArrayList<VirtualFile>();
        }
        for (VirtualFile file : files) {
            if (file == null) {
                throw new IllegalArgumentException("Null virtual file in " + files);
            }
            classPath.add(file);
        }
        this.setClassPath(classPath);
    }

    public void prependClassPath(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException("Null files");
        }
        List<VirtualFile> classPath = this.getMutableClassPath();
        if (classPath == null) {
            classPath = new ArrayList<VirtualFile>();
        }
        for (int i = files.length - 1; i >= 0; --i) {
            VirtualFile file = files[i];
            if (file == null) {
                throw new IllegalArgumentException("Null virtual file in " + Arrays.toString(files));
            }
            classPath.add(0, file);
        }
        this.setClassPath(classPath);
    }

    public void prependClassPath(List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException("Null files");
        }
        List<VirtualFile> classPath = this.getMutableClassPath();
        if (classPath == null) {
            classPath = new ArrayList<VirtualFile>();
        }
        for (int i = files.size() - 1; i >= 0; --i) {
            VirtualFile file = files.get(i);
            if (file == null) {
                throw new IllegalArgumentException("Null virtual file in " + files);
            }
            classPath.add(0, file);
        }
        this.setClassPath(classPath);
    }

    public void appendClassPath(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException("Null files");
        }
        List<VirtualFile> classPath = this.getMutableClassPath();
        if (classPath == null) {
            classPath = new ArrayList<VirtualFile>();
        }
        for (VirtualFile file : files) {
            if (file == null) {
                throw new IllegalArgumentException("Null virtual file in " + Arrays.toString(files));
            }
            classPath.add(file);
        }
        this.setClassPath(classPath);
    }

    public void removeClassPath(VirtualFile ... files) {
        if (files == null || files.length == 0) {
            return;
        }
        for (VirtualFile file : files) {
            this.classPath.remove(file);
        }
    }

    public VFSDeploymentContext getTopLevel() {
        return (VFSDeploymentContext)super.getTopLevel();
    }

    public VFSDeploymentResourceLoader getResourceLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        this.loader = new VFSDeploymentResourceLoaderImpl(this.getRoot());
        return this.loader;
    }

    protected DeploymentUnit createDeploymentUnit() {
        return new AbstractVFSDeploymentUnit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        try {
            this.root.cleanup();
        }
        finally {
            super.cleanup();
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.root = (VirtualFile)in.readObject();
        boolean isNullOrEmpty = in.readBoolean();
        if (!isNullOrEmpty) {
            this.metaDataLocations = (List)in.readObject();
        }
        this.classPath = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.root);
        boolean isNullOrEmpty = this.metaDataLocations == null || this.metaDataLocations.isEmpty();
        out.writeBoolean(isNullOrEmpty);
        if (!isNullOrEmpty) {
            out.writeObject(this.metaDataLocations);
        }
        out.writeObject(this.classPath);
    }
}

